/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;

abstract class AbstractPropertiesSystemTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final TransactionManager transactionManager;
    private final Supplier<Map<ConnectorId, Map<String, PropertyMetadata<?>>>> propertySupplier;

    protected AbstractPropertiesSystemTable(String tableName, TransactionManager transactionManager, Supplier<Map<ConnectorId, Map<String, PropertyMetadata<?>>>> propertySupplier) {
        this.tableMetadata = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", tableName)).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("property_name", (Type)VarcharType.createUnboundedVarcharType()).column("default_value", (Type)VarcharType.createUnboundedVarcharType()).column("type", (Type)VarcharType.createUnboundedVarcharType()).column("description", (Type)VarcharType.createUnboundedVarcharType()).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.propertySupplier = Objects.requireNonNull(propertySupplier, "propertySupplier is null");
    }

    public final SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public final ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public final RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        TransactionId transactionId = ((GlobalSystemTransactionHandle)transactionHandle).getTransactionId();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.tableMetadata);
        Map<ConnectorId, Map<String, PropertyMetadata<?>>> connectorProperties = this.propertySupplier.get();
        for (Map.Entry<String, ConnectorId> entry : new TreeMap<String, ConnectorId>(this.transactionManager.getCatalogNames(transactionId)).entrySet()) {
            String catalog = entry.getKey();
            TreeMap properties = new TreeMap((Map)connectorProperties.getOrDefault(entry.getValue(), (Map<String, PropertyMetadata<?>>)ImmutableMap.of()));
            for (PropertyMetadata propertyMetadata : properties.values()) {
                table.addRow(new Object[]{catalog, propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()});
            }
        }
        return table.build().cursor();
    }
}

