/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public class ConnectorAwareNodeManager
implements NodeManager {
    private final InternalNodeManager nodeManager;
    private final String environment;
    private final ConnectorId connectorId;

    public ConnectorAwareNodeManager(InternalNodeManager nodeManager, String environment, ConnectorId connectorId) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public Set<Node> getAllNodes() {
        return ImmutableSet.builder().addAll(this.getWorkerNodes()).addAll(this.nodeManager.getCoordinators()).build();
    }

    public Set<Node> getWorkerNodes() {
        return ImmutableSet.copyOf(this.nodeManager.getActiveConnectorNodes(this.connectorId));
    }

    public Node getCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    public String getEnvironment() {
        return this.environment;
    }
}

