/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.LogicalRowExpressions;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SpatialJoinUtils {
    public static final String ST_CONTAINS = "st_contains";
    public static final String ST_WITHIN = "st_within";
    public static final String ST_INTERSECTS = "st_intersects";
    public static final String ST_DISTANCE = "st_distance";

    private SpatialJoinUtils() {
    }

    public static List<FunctionCall> extractSupportedSpatialFunctions(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(SpatialJoinUtils::isSupportedSpatialFunction).collect(ImmutableList.toImmutableList());
    }

    public static List<CallExpression> extractSupportedSpatialFunctions(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> SpatialJoinUtils.isSupportedSpatialFunction(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(FunctionCall functionCall) {
        String functionName = functionCall.getName().toString();
        return functionName.equalsIgnoreCase(ST_CONTAINS) || functionName.equalsIgnoreCase(ST_WITHIN) || functionName.equalsIgnoreCase(ST_INTERSECTS);
    }

    private static boolean isSupportedSpatialFunction(CallExpression call, FunctionManager functionManager) {
        String functionName = functionManager.getFunctionMetadata(call.getFunctionHandle()).getName();
        return functionName.equalsIgnoreCase(ST_CONTAINS) || functionName.equalsIgnoreCase(ST_WITHIN) || functionName.equalsIgnoreCase(ST_INTERSECTS);
    }

    public static List<ComparisonExpression> extractSupportedSpatialComparisons(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(ComparisonExpression.class::isInstance).map(ComparisonExpression.class::cast).filter(SpatialJoinUtils::isSupportedSpatialComparison).collect(ImmutableList.toImmutableList());
    }

    public static List<CallExpression> extractSupportedSpatialComparisons(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> new FunctionResolution(functionManager).isComparisonFunction(call.getFunctionHandle())).filter(call -> SpatialJoinUtils.isSupportedSpatialComparison(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(ComparisonExpression expression) {
        switch (expression.getOperator()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getLeft());
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getRight());
            }
        }
        return false;
    }

    private static boolean isSupportedSpatialComparison(CallExpression expression, FunctionManager functionManager) {
        FunctionMetadata metadata = functionManager.getFunctionMetadata(expression.getFunctionHandle());
        Preconditions.checkArgument((metadata.getOperatorType().isPresent() && ((OperatorType)metadata.getOperatorType().get()).isComparisonOperator() ? 1 : 0) != 0);
        switch ((OperatorType)metadata.getOperatorType().get()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(0), functionManager);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(1), functionManager);
            }
        }
        return false;
    }

    private static boolean isSTDistance(Expression expression) {
        if (expression instanceof FunctionCall) {
            return ((FunctionCall)expression).getName().toString().equalsIgnoreCase(ST_DISTANCE);
        }
        return false;
    }

    private static boolean isSTDistance(RowExpression expression, FunctionManager functionManager) {
        if (expression instanceof CallExpression) {
            return functionManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getName().equalsIgnoreCase(ST_DISTANCE);
        }
        return false;
    }
}

