/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.ByteArrayBlockBuilder;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.google.common.base.Preconditions;

public final class UnknownType
extends AbstractType
implements FixedWidthType {
    public static final UnknownType UNKNOWN = new UnknownType();
    public static final String NAME = "unknown";

    private UnknownType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), Boolean.TYPE);
    }

    public int getFixedSize() {
        return 1;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public long hash(Block block, int position) {
        Preconditions.checkArgument((boolean)block.isNull(position), (Object)"Expected NULL value for UnknownType");
        return 0L;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Preconditions.checkArgument((boolean)leftBlock.isNull(leftPosition), (Object)"Expected NULL value for UnknownType");
        Preconditions.checkArgument((boolean)rightBlock.isNull(rightPosition), (Object)"Expected NULL value for UnknownType");
        return true;
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Preconditions.checkArgument((boolean)leftBlock.isNull(leftPosition), (Object)"Expected NULL value for UnknownType");
        Preconditions.checkArgument((boolean)rightBlock.isNull(rightPosition), (Object)"Expected NULL value for UnknownType");
        return 0;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        Preconditions.checkArgument((boolean)block.isNull(position), (Object)"Expected NULL value for UnknownType");
        return null;
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        blockBuilder.appendNull();
    }

    public boolean getBoolean(Block block, int position) {
        Preconditions.checkArgument((boolean)block.isNull(position));
        return false;
    }

    @Deprecated
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        Preconditions.checkArgument((!value ? 1 : 0) != 0);
        blockBuilder.appendNull();
    }
}

