/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.AnalyzePropertiesSystemTable;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.connector.system.ColumnPropertiesSystemTable;
import com.facebook.presto.connector.system.GlobalSystemConnectorFactory;
import com.facebook.presto.connector.system.NodeSystemTable;
import com.facebook.presto.connector.system.SchemaPropertiesSystemTable;
import com.facebook.presto.connector.system.TablePropertiesSystemTable;
import com.facebook.presto.connector.system.TransactionsSystemTable;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsCalculatorModule;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DeallocateTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PrepareTask;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.SetPathTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.resourceGroups.NoOpResourceGroupManager;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.metadata.AnalyzePropertyManager;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.GenericPartitioningSpillerFactory;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.gen.RowExpressionPredicateCompiler;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.testing.TreeAssertions;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetPath;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.management.MBeanServer;
import org.intellij.lang.annotations.Language;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.testing.TestingMBeanServer;

public class LocalQueryRunner
implements QueryRunner {
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final PlanFragmenter planFragmenter;
    private final InMemoryNodeManager nodeManager;
    private final TypeRegistry typeRegistry;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final MetadataManager metadata;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final CostCalculator estimatedExchangesCostCalculator;
    private final TaskCountEstimator taskCountEstimator;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final BlockEncodingManager blockEncodingManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private final SpillerFactory spillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final JoinCompiler joinCompiler;
    private final ConnectorManager connectorManager;
    private final PluginManager pluginManager;
    private final ImmutableMap<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;
    private final boolean alwaysRevokeMemory;
    private final NodeSpillConfig nodeSpillConfig;
    private final NodeSchedulerConfig nodeSchedulerConfig;
    private boolean printPlan;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LocalQueryRunner(Session defaultSession) {
        this(defaultSession, new FeaturesConfig(), new NodeSpillConfig(), false, false);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig) {
        this(defaultSession, featuresConfig, new NodeSpillConfig(), false, false);
    }

    public LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory) {
        this(defaultSession, featuresConfig, nodeSpillConfig, withInitialTransaction, alwaysRevokeMemory, 1);
    }

    private LocalQueryRunner(Session defaultSession, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig, boolean withInitialTransaction, boolean alwaysRevokeMemory, int nodeCountForStats) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        this.nodeSpillConfig = Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.alwaysRevokeMemory = alwaysRevokeMemory;
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager();
        this.typeRegistry = new TypeRegistry();
        this.pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
        this.indexManager = new IndexManager();
        this.nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(true);
        NodeScheduler nodeScheduler = new NodeScheduler(new LegacyNetworkTopology(), this.nodeManager, this.nodeSchedulerConfig, new NodeTaskMap(this.finalizerService));
        this.pageSinkManager = new PageSinkManager();
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, catalogManager, this.notificationExecutor);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler);
        this.blockEncodingManager = new BlockEncodingManager((TypeManager)this.typeRegistry, new BlockEncoding[0]);
        this.metadata = new MetadataManager(featuresConfig, this.typeRegistry, this.blockEncodingManager, new SessionPropertyManager(new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig)), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), this.transactionManager);
        this.splitManager = new SplitManager(this.metadata, new QueryManagerConfig(), this.nodeSchedulerConfig);
        this.planFragmenter = new PlanFragmenter(this.metadata, this.nodePartitioningManager, new QueryManagerConfig(), this.sqlParser);
        this.joinCompiler = new JoinCompiler(this.metadata, featuresConfig);
        this.pageIndexerFactory = new GroupByHashPageIndexerFactory(this.joinCompiler);
        this.statsCalculator = StatsCalculatorModule.createNewStatsCalculator(this.metadata);
        this.taskCountEstimator = new TaskCountEstimator(() -> nodeCountForStats);
        this.costCalculator = new CostCalculatorUsingExchanges(this.taskCountEstimator);
        this.estimatedExchangesCostCalculator = new CostCalculatorWithEstimatedExchanges(this.costCalculator, this.taskCountEstimator);
        this.accessControl = new TestingAccessControlManager(this.transactionManager);
        this.pageSourceManager = new PageSourceManager();
        this.pageFunctionCompiler = new PageFunctionCompiler((Metadata)this.metadata, 0);
        this.expressionCompiler = new ExpressionCompiler(this.metadata, this.pageFunctionCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(this.metadata);
        NodeInfo nodeInfo = new NodeInfo("test");
        this.connectorManager = new ConnectorManager(this.metadata, catalogManager, this.accessControl, this.splitManager, this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, new HandleResolver(), this.nodeManager, nodeInfo, this.typeRegistry, this.pageSorter, this.pageIndexerFactory, this.transactionManager, new RowExpressionDomainTranslator(this.metadata), new RowExpressionPredicateCompiler(this.metadata), new RowExpressionDeterminismEvaluator(this.metadata.getFunctionManager()));
        GlobalSystemConnectorFactory globalSystemConnectorFactory = new GlobalSystemConnectorFactory((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(this.metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(this.transactionManager, this.metadata), (Object)new TablePropertiesSystemTable(this.transactionManager, this.metadata), (Object)new ColumnPropertiesSystemTable(this.transactionManager, this.metadata), (Object)new AnalyzePropertiesSystemTable(this.transactionManager, this.metadata), (Object[])new SystemTable[]{new TransactionsSystemTable(this.typeRegistry, this.transactionManager)}), (Set<Procedure>)ImmutableSet.of());
        this.pluginManager = new PluginManager(nodeInfo, new PluginManagerConfig(), this.connectorManager, this.metadata, new NoOpResourceGroupManager(), this.accessControl, new PasswordAuthenticatorManager(), new EventListenerManager(), this.blockEncodingManager, new SessionPropertyDefaults(nodeInfo), this.typeRegistry);
        this.connectorManager.addConnectorFactory(globalSystemConnectorFactory);
        this.connectorManager.createConnection("system", "system", (Map<String, String>)ImmutableMap.of());
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog("testing_catalog"));
        this.defaultSession = new Session(defaultSession.getQueryId(), withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(false)) : defaultSession.getTransactionId(), defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getPath(), defaultSession.getTraceToken(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getClientTags(), defaultSession.getClientCapabilities(), defaultSession.getResourceEstimates(), defaultSession.getStartTime(), defaultSession.getSystemProperties(), defaultSession.getConnectorProperties(), defaultSession.getUnprocessedCatalogProperties(), this.metadata.getSessionPropertyManager(), defaultSession.getPreparedStatements());
        this.dataDefinitionTask = ImmutableMap.builder().put(CreateTable.class, (Object)new CreateTableTask()).put(CreateView.class, (Object)new CreateViewTask((JsonCodec<ViewDefinition>)JsonCodec.jsonCodec(ViewDefinition.class), this.sqlParser, new FeaturesConfig())).put(DropTable.class, (Object)new DropTableTask()).put(DropView.class, (Object)new DropViewTask()).put(RenameColumn.class, (Object)new RenameColumnTask()).put(RenameTable.class, (Object)new RenameTableTask()).put(ResetSession.class, (Object)new ResetSessionTask()).put(SetSession.class, (Object)new SetSessionTask()).put(Prepare.class, (Object)new PrepareTask(this.sqlParser)).put(Deallocate.class, (Object)new DeallocateTask()).put(StartTransaction.class, (Object)new StartTransactionTask()).put(Commit.class, (Object)new CommitTask()).put(Rollback.class, (Object)new RollbackTask()).put(SetPath.class, (Object)new SetPathTask()).build();
        SpillerStats spillerStats = new SpillerStats();
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.blockEncodingManager, spillerStats, featuresConfig, nodeSpillConfig);
        this.partitioningSpillerFactory = new GenericPartitioningSpillerFactory(this.singleStreamSpillerFactory);
        this.spillerFactory = new GenericSpillerFactory(this.singleStreamSpillerFactory);
    }

    public static LocalQueryRunner queryRunnerWithInitialTransaction(Session defaultSession) {
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Already in transaction!");
        return new LocalQueryRunner(defaultSession, new FeaturesConfig(), new NodeSpillConfig(), true, false);
    }

    public static LocalQueryRunner queryRunnerWithFakeNodeCountForStats(Session defaultSession, int nodeCount) {
        return new LocalQueryRunner(defaultSession, new FeaturesConfig(), new NodeSpillConfig(), false, false, nodeCount);
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.connectorManager.stop();
        this.finalizerService.destroy();
        this.singleStreamSpillerFactory.destroy();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public TypeRegistry getTypeManager() {
        return this.typeRegistry;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    @Override
    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    @Override
    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    @Override
    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    public CostCalculator getEstimatedExchangesCostCalculator() {
        return this.estimatedExchangesCostCalculator;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ExecutorService getExecutor() {
        return this.notificationExecutor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.yieldExecutor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return this.expressionCompiler;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeConnector(new ConnectorId(catalogName));
        this.connectorManager.addConnectorFactory(connectorFactory);
        this.connectorManager.createConnection(catalogName, connectorFactory.getName(), properties);
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager, this.accessControl).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return this.executeWithPlan(session, sql, new DefaultWarningCollector(new WarningCollectorConfig())).getMaterializedResult();
    }

    @Override
    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        return this.inTransaction(session, transactionSession -> this.executeInternal((Session)transactionSession, sql, warningCollector));
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.defaultSession, transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.transactionManager, this.accessControl).singleStatement().execute(session, transactionSessionConsumer);
    }

    /*
     * Exception decompiling
     */
    private QueryRunner.MaterializedResultWithPlan executeInternal(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        Plan plan = this.createPlan(session, sql, WarningCollector.NOOP);
        return this.createDrivers(session, plan, outputFactory, taskContext);
    }

    private List<Driver> createDrivers(Session session, Plan plan, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata.getFunctionManager(), plan.getStatsAndCosts(), session, 0, false));
        }
        if (!(subplan = this.planFragmenter.createSubPlans(session, plan, true, new PlanNodeIdAllocator(){

            public PlanNodeId getNextId() {
                throw new UnsupportedOperationException();
            }
        }, WarningCollector.NOOP)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.metadata, this.sqlParser, Optional.empty(), this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), new TaskManagerConfig().setTaskConcurrency(4), this.spillerFactory, this.singleStreamSpillerFactory, this.partitioningSpillerFactory, this.blockEncodingManager, new PagesIndex.TestingFactory(false), this.joinCompiler, new LookupJoinOperators(), new OrderingCompiler(), (JsonCodec<TableCommitContext>)JsonCodec.jsonCodec(TableCommitContext.class));
        StageExecutionDescriptor stageExecutionDescriptor = subplan.getFragment().getStageExecutionDescriptor();
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, stageExecutionDescriptor, subplan.getFragment().getRoot(), subplan.getFragment().getPartitioningScheme().getOutputLayout(), plan.getTypes(), subplan.getFragment().getTableScanSchedulingOrder(), outputFactory, new TaskExchangeClientManager(ignored -> {
            throw new UnsupportedOperationException();
        }));
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            SplitSource splitSource = this.splitManager.getSplits(session, tableScan.getTable(), stageExecutionDescriptor.isScanGroupedExecution(tableScan.getId()) ? ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING : ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : LocalQueryRunner.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        ImmutableSet tableScanPlanNodeIds = ImmutableSet.copyOf(subplan.getFragment().getTableScanSchedulingOrder());
        for (TaskSource source : sources) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(source.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            boolean partitioned = tableScanPlanNodeIds.contains(driverFactory.getSourceId().get());
            for (ScheduledSplit split : source.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSource(new TaskSource(split.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    @Override
    public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        return this.createPlan(session, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, WarningCollector warningCollector) {
        return this.createPlan(session, sql, stage, true, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode, WarningCollector warningCollector) {
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, sql, warningCollector);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)ParsingUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        return this.createPlan(session, sql, this.getPlanOptimizers(forceSingleNode), stage, warningCollector);
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean forceSingleNode) {
        FeaturesConfig featuresConfig = new FeaturesConfig().setDistributedIndexJoinsEnabled(false).setOptimizeHashGeneration(true);
        return new PlanOptimizers(this.metadata, this.sqlParser, featuresConfig, forceSingleNode, new MBeanExporter((MBeanServer)new TestingMBeanServer()), this.splitManager, this.pageSourceManager, this.statsCalculator, this.costCalculator, this.estimatedExchangesCostCalculator, new CostComparator(featuresConfig), this.taskCountEstimator).get();
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, WarningCollector warningCollector) {
        return this.createPlan(session, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, LogicalPlanner.Stage stage, WarningCollector warningCollector) {
        Statement wrappedStatement = this.sqlParser.createStatement(sql, ParsingUtil.createParsingOptions(session, warningCollector));
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, wrappedStatement, warningCollector);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (ParsingOptions)ParsingUtil.createParsingOptions(session), (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        QueryExplainer queryExplainer = new QueryExplainer(optimizers, this.planFragmenter, (Metadata)this.metadata, (AccessControl)this.accessControl, this.sqlParser, this.statsCalculator, this.costCalculator, (Map<Class<? extends Statement>, DataDefinitionTask<?>>)this.dataDefinitionTask);
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(queryExplainer), preparedQuery.getParameters(), warningCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(wrappedStatement instanceof Explain, session, optimizers, new PlanSanityChecker(true), idAllocator, this.metadata, this.sqlParser, this.statsCalculator, this.costCalculator, warningCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        return logicalPlanner.plan(analysis, stage);
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).findAll();
    }

    private static /* synthetic */ boolean lambda$executeInternal$5(OperatorContext operatorContext) {
        return operatorContext.getOperatorStats().getRevocableMemoryReservation().getValue() > 0.0;
    }

    private static /* synthetic */ Consumer lambda$executeInternal$4(AtomicReference builder, Session session, List types) {
        builder.compareAndSet(null, MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)types));
        return ((MaterializedResult.Builder)builder.get())::page;
    }
}

