/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import java.util.Objects;

public final class RowExpressionOptimizer
implements ExpressionOptimizer {
    private final Metadata metadata;

    public RowExpressionOptimizer(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public RowExpression optimize(RowExpression rowExpression, ExpressionOptimizer.Level level, ConnectorSession session) {
        if (level == ExpressionOptimizer.Level.SERIALIZABLE) {
            return LiteralEncoder.toRowExpression(RowExpressionInterpreter.rowExpressionInterpreter(rowExpression, this.metadata, session).evaluate(), rowExpression.getType());
        }
        if (level == ExpressionOptimizer.Level.MOST_OPTIMIZED) {
            return LiteralEncoder.toRowExpression(new RowExpressionInterpreter(rowExpression, this.metadata, session, true).optimize(), rowExpression.getType());
        }
        throw new IllegalArgumentException("Unrecognized optimization level: " + level);
    }
}

