/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RowExpressionFormatter {
    private final ConnectorSession session;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;

    public RowExpressionFormatter(ConnectorSession session, FunctionManager functionManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.functionMetadataManager = Objects.requireNonNull(functionManager, "function manager is null");
        this.standardFunctionResolution = new FunctionResolution(functionManager);
    }

    public String formatRowExpression(RowExpression expression) {
        return (String)expression.accept((RowExpressionVisitor)new Formatter(), null);
    }

    public List<String> formatRowExpressions(List<RowExpression> rowExpressions) {
        return rowExpressions.stream().map(this::formatRowExpression).collect(Collectors.toList());
    }

    public class Formatter
    implements RowExpressionVisitor<String, Void> {
        public String visitCall(CallExpression node, Void context) {
            if (RowExpressionFormatter.this.standardFunctionResolution.isArithmeticFunction(node.getFunctionHandle()) || RowExpressionFormatter.this.standardFunctionResolution.isComparisonFunction(node.getFunctionHandle())) {
                String operation = ((OperatorType)RowExpressionFormatter.this.functionMetadataManager.getFunctionMetadata(node.getFunctionHandle()).getOperatorType().get()).getOperator();
                return String.join((CharSequence)(" " + operation + " "), (Iterable)RowExpressionFormatter.this.formatRowExpressions(node.getArguments()).stream().map(e -> "(" + e + ")").collect(ImmutableList.toImmutableList()));
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isCastFunction(node.getFunctionHandle())) {
                return String.format("CAST(%s AS %s)", RowExpressionFormatter.this.formatRowExpression((RowExpression)node.getArguments().get(0)), node.getType().getDisplayName());
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isNegateFunction(node.getFunctionHandle())) {
                return "-(" + RowExpressionFormatter.this.formatRowExpression((RowExpression)node.getArguments().get(0)) + ")";
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isSubscriptFunction(node.getFunctionHandle())) {
                return RowExpressionFormatter.this.formatRowExpression((RowExpression)node.getArguments().get(0)) + "[" + RowExpressionFormatter.this.formatRowExpression((RowExpression)node.getArguments().get(1)) + "]";
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isBetweenFunction(node.getFunctionHandle())) {
                List<String> formattedExpresions = RowExpressionFormatter.this.formatRowExpressions(node.getArguments());
                return String.format("%s BETWEEN (%s) AND (%s)", formattedExpresions.get(0), formattedExpresions.get(1), formattedExpresions.get(2));
            }
            return node.getDisplayName() + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(node.getArguments())) + ")";
        }

        public String visitSpecialForm(SpecialFormExpression node, Void context) {
            if (node.getForm().equals((Object)SpecialFormExpression.Form.AND) || node.getForm().equals((Object)SpecialFormExpression.Form.OR)) {
                return String.join((CharSequence)(" " + node.getForm() + " "), (Iterable)RowExpressionFormatter.this.formatRowExpressions(node.getArguments()).stream().map(e -> "(" + e + ")").collect(ImmutableList.toImmutableList()));
            }
            return node.getForm().name() + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(node.getArguments())) + ")";
        }

        public String visitInputReference(InputReferenceExpression node, Void context) {
            return node.toString();
        }

        public String visitLambda(LambdaDefinitionExpression node, Void context) {
            return "(" + String.join((CharSequence)", ", node.getArguments()) + ") -> " + RowExpressionFormatter.this.formatRowExpression(node.getBody());
        }

        public String visitVariableReference(VariableReferenceExpression node, Void context) {
            return node.getName();
        }

        public String visitConstant(ConstantExpression node, Void context) {
            Object value = LiteralInterpreter.evaluate(RowExpressionFormatter.this.session, node);
            if (value == null) {
                return String.valueOf(null);
            }
            Type type = node.getType();
            if (node.getType().getJavaType() == Block.class) {
                Block block = (Block)value;
                return String.format("[Block: position count: %s; size: %s bytes]", block.getPositionCount(), block.getRetainedSizeInBytes());
            }
            return type.getDisplayName().toUpperCase() + " " + value.toString();
        }
    }
}

