/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IOPlanPrinter {
    private final Metadata metadata;
    private final Session session;

    private IOPlanPrinter(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public static String textIOPlan(PlanNode plan, Metadata metadata, Session session) {
        return new IOPlanPrinter(metadata, session).print(plan);
    }

    private String print(PlanNode plan) {
        IOPlan.IOPlanBuilder ioPlanBuilder = new IOPlan.IOPlanBuilder();
        plan.accept(new IOPlanVisitor(), ioPlanBuilder);
        return JsonCodec.jsonCodec(IOPlan.class).toJson((Object)ioPlanBuilder.build());
    }

    private class IOPlanVisitor
    extends InternalPlanVisitor<Void, IOPlan.IOPlanBuilder> {
        private IOPlanVisitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, IOPlan.IOPlanBuilder context) {
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, IOPlan.IOPlanBuilder context) {
            TableMetadata tableMetadata = IOPlanPrinter.this.metadata.getTableMetadata(IOPlanPrinter.this.session, node.getTable());
            context.addInputTableColumnInfo(new IOPlan.TableColumnInfo(new CatalogSchemaTableName(tableMetadata.getConnectorId().getCatalogName(), tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName()), this.parseConstraints(node.getTable(), node.getCurrentConstraint())));
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, IOPlan.IOPlanBuilder context) {
            TableWriterNode.WriterTarget writerTarget = node.getTarget();
            if (writerTarget instanceof TableWriterNode.CreateHandle) {
                TableWriterNode.CreateHandle createHandle = (TableWriterNode.CreateHandle)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(createHandle.getHandle().getConnectorId().getCatalogName(), createHandle.getSchemaTableName().getSchemaName(), createHandle.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.InsertHandle) {
                TableWriterNode.InsertHandle insertHandle = (TableWriterNode.InsertHandle)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(insertHandle.getHandle().getConnectorId().getCatalogName(), insertHandle.getSchemaTableName().getSchemaName(), insertHandle.getSchemaTableName().getTableName()));
            } else if (writerTarget instanceof TableWriterNode.DeleteHandle) {
                TableWriterNode.DeleteHandle deleteHandle = (TableWriterNode.DeleteHandle)writerTarget;
                context.setOutputTable(new CatalogSchemaTableName(deleteHandle.getHandle().getConnectorId().getCatalogName(), deleteHandle.getSchemaTableName().getSchemaName(), deleteHandle.getSchemaTableName().getTableName()));
            } else {
                if (writerTarget instanceof TableWriterNode.CreateName || writerTarget instanceof TableWriterNode.InsertReference) {
                    throw new IllegalStateException(String.format("%s should not appear in final plan", writerTarget.getClass().getSimpleName()));
                }
                throw new IllegalStateException(String.format("Unknown WriterTarget subclass %s", writerTarget.getClass().getSimpleName()));
            }
            return this.processChildren(node, context);
        }

        private Set<ColumnConstraint> parseConstraints(TableHandle tableHandle, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            ImmutableSet.Builder columnConstraints = ImmutableSet.builder();
            for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
                ColumnMetadata columnMetadata = IOPlanPrinter.this.metadata.getColumnMetadata(IOPlanPrinter.this.session, tableHandle, (ColumnHandle)entry.getKey());
                columnConstraints.add((Object)new ColumnConstraint(columnMetadata.getName(), columnMetadata.getType().getTypeSignature(), this.parseDomain(((Domain)entry.getValue()).simplify())));
            }
            return columnConstraints.build();
        }

        private FormattedDomain parseDomain(Domain domain) {
            ImmutableSet.Builder formattedRanges = ImmutableSet.builder();
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> formattedRanges.addAll((Iterable)ranges.getOrderedRanges().stream().map(range -> new FormattedRange(this.formatMarker(range.getLow()), this.formatMarker(range.getHigh()))).collect(ImmutableSet.toImmutableSet())), discreteValues -> formattedRanges.addAll((Iterable)discreteValues.getValues().stream().map(value -> this.getVarcharValue(type, value)).map(value -> new FormattedMarker(Optional.of(value), Marker.Bound.EXACTLY)).map(marker -> new FormattedRange((FormattedMarker)marker, (FormattedMarker)marker)).collect(ImmutableSet.toImmutableSet())), allOrNone -> {
                throw new IllegalStateException("Unreachable AllOrNone consumer");
            });
            return new FormattedDomain(domain.isNullAllowed(), (Set<FormattedRange>)formattedRanges.build());
        }

        private FormattedMarker formatMarker(Marker marker) {
            if (!marker.getValueBlock().isPresent()) {
                return new FormattedMarker(Optional.empty(), marker.getBound());
            }
            return new FormattedMarker(Optional.of(this.getVarcharValue(marker.getType(), marker.getValue())), marker.getBound());
        }

        private String getVarcharValue(Type type, Object value) {
            if (type instanceof VarcharType) {
                return ((Slice)value).toStringUtf8();
            }
            if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType) {
                return ((Long)value).toString();
            }
            if (type instanceof BooleanType) {
                return ((Boolean)value).toString();
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported data type in EXPLAIN (TYPE IO): %s", type.getDisplayName()));
        }

        private Void processChildren(PlanNode node, IOPlan.IOPlanBuilder context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }

    public static class FormattedMarker {
        private final Optional<String> value;
        private final Marker.Bound bound;

        @JsonCreator
        public FormattedMarker(@JsonProperty(value="value") Optional<String> value, @JsonProperty(value="bound") Marker.Bound bound) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.bound = Objects.requireNonNull(bound, "bound is null");
        }

        @JsonProperty
        public Optional<String> getValue() {
            return this.value;
        }

        @JsonProperty
        public Marker.Bound getBound() {
            return this.bound;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedMarker o = (FormattedMarker)obj;
            return Objects.equals(this.value, o.value) && Objects.equals(this.bound, o.bound);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.bound);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("bound", (Object)this.bound).toString();
        }
    }

    public static class FormattedRange {
        private final FormattedMarker low;
        private final FormattedMarker high;

        @JsonCreator
        public FormattedRange(@JsonProperty(value="low") FormattedMarker low, @JsonProperty(value="high") FormattedMarker high) {
            this.low = Objects.requireNonNull(low, "low is null");
            this.high = Objects.requireNonNull(high, "high is null");
        }

        @JsonProperty
        public FormattedMarker getLow() {
            return this.low;
        }

        @JsonProperty
        public FormattedMarker getHigh() {
            return this.high;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedRange o = (FormattedRange)obj;
            return Objects.equals(this.low, o.low) && Objects.equals(this.high, o.high);
        }

        public int hashCode() {
            return Objects.hash(this.low, this.high);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("low", (Object)this.low).add("high", (Object)this.high).toString();
        }
    }

    public static class FormattedDomain {
        private final boolean nullsAllowed;
        private final Set<FormattedRange> ranges;

        @JsonCreator
        public FormattedDomain(@JsonProperty(value="nullsAllowed") boolean nullsAllowed, @JsonProperty(value="ranges") Set<FormattedRange> ranges) {
            this.nullsAllowed = nullsAllowed;
            this.ranges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
        }

        @JsonProperty
        public boolean isNullsAllowed() {
            return this.nullsAllowed;
        }

        @JsonProperty
        public Set<FormattedRange> getRanges() {
            return this.ranges;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FormattedDomain o = (FormattedDomain)obj;
            return Objects.equals(this.nullsAllowed, o.nullsAllowed) && Objects.equals(this.ranges, o.ranges);
        }

        public int hashCode() {
            return Objects.hash(this.nullsAllowed, this.ranges);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nullsAllowed", this.nullsAllowed).add("ranges", this.ranges).toString();
        }
    }

    public static class ColumnConstraint {
        private final String columnName;
        private final TypeSignature typeSignature;
        private final FormattedDomain domain;

        @JsonCreator
        public ColumnConstraint(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="domain") FormattedDomain domain) {
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.typeSignature = Objects.requireNonNull(typeSignature, "type is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public String getColumnName() {
            return this.columnName;
        }

        @JsonProperty
        public TypeSignature getTypeSignature() {
            return this.typeSignature;
        }

        @JsonProperty
        public FormattedDomain getDomain() {
            return this.domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnConstraint o = (ColumnConstraint)obj;
            return Objects.equals(this.columnName, o.columnName) && Objects.equals(this.typeSignature, o.typeSignature) && Objects.equals(this.domain, o.domain);
        }

        public int hashCode() {
            return Objects.hash(this.columnName, this.typeSignature, this.domain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("typeSignature", (Object)this.typeSignature).add("domain", (Object)this.domain).toString();
        }
    }

    public static class IOPlan {
        private final Set<TableColumnInfo> inputTableColumnInfos;
        private final Optional<CatalogSchemaTableName> outputTable;

        @JsonCreator
        public IOPlan(@JsonProperty(value="inputTableColumnInfos") Set<TableColumnInfo> inputTableColumnInfos, @JsonProperty(value="outputTable") Optional<CatalogSchemaTableName> outputTable) {
            this.inputTableColumnInfos = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inputTableColumnInfos, "inputTableColumnInfos is null"));
            this.outputTable = Objects.requireNonNull(outputTable, "outputTable is null");
        }

        @JsonProperty
        public Set<TableColumnInfo> getInputTableColumnInfos() {
            return this.inputTableColumnInfos;
        }

        @JsonProperty
        public Optional<CatalogSchemaTableName> getOutputTable() {
            return this.outputTable;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IOPlan o = (IOPlan)obj;
            return Objects.equals(this.inputTableColumnInfos, o.inputTableColumnInfos) && Objects.equals(this.outputTable, o.outputTable);
        }

        public int hashCode() {
            return Objects.hash(this.inputTableColumnInfos, this.outputTable);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inputTableColumnInfos", this.inputTableColumnInfos).add("outputTable", this.outputTable).toString();
        }

        public static class TableColumnInfo {
            private final CatalogSchemaTableName table;
            private final Set<ColumnConstraint> columnConstraints;

            @JsonCreator
            public TableColumnInfo(@JsonProperty(value="table") CatalogSchemaTableName table, @JsonProperty(value="columnConstraints") Set<ColumnConstraint> columnConstraints) {
                this.table = Objects.requireNonNull(table, "table is null");
                this.columnConstraints = Objects.requireNonNull(columnConstraints, "columnConstraints is null");
            }

            @JsonProperty
            public CatalogSchemaTableName getTable() {
                return this.table;
            }

            @JsonProperty
            public Set<ColumnConstraint> getColumnConstraints() {
                return this.columnConstraints;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                TableColumnInfo o = (TableColumnInfo)obj;
                return Objects.equals(this.table, o.table) && Objects.equals(this.columnConstraints, o.columnConstraints);
            }

            public int hashCode() {
                return Objects.hash(this.table, this.columnConstraints);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columnConstraints", this.columnConstraints).toString();
            }
        }

        protected static class IOPlanBuilder {
            private Set<TableColumnInfo> inputTableColumnInfos = new HashSet<TableColumnInfo>();
            private Optional<CatalogSchemaTableName> outputTable = Optional.empty();

            private IOPlanBuilder() {
            }

            private void addInputTableColumnInfo(TableColumnInfo tableColumnInfo) {
                this.inputTableColumnInfos.add(tableColumnInfo);
            }

            private void setOutputTable(CatalogSchemaTableName outputTable) {
                this.outputTable = Optional.of(outputTable);
            }

            private IOPlan build() {
                return new IOPlan(this.inputTableColumnInfos, this.outputTable);
            }
        }
    }
}

