/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final boolean temporaryTable;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputs, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="temporaryTable") boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputs, "outputs is null")));
        this.assignments = Collections.unmodifiableMap(new HashMap<Symbol, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputs), "assignments does not cover all of outputs");
        this.temporaryTable = temporaryTable;
        this.currentConstraint = null;
        this.enforcedConstraint = null;
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments) {
        this(id, table, outputs, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint) {
        this(id, table, outputs, assignments, currentConstraint, enforcedConstraint, false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputs, "outputs is null")));
        this.assignments = Collections.unmodifiableMap(new HashMap<Symbol, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputs), "assignments does not cover all of outputs");
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "currentConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.temporaryTable = temporaryTable;
        if (!currentConstraint.isAll() || !enforcedConstraint.isAll()) {
            TableScanNode.checkArgument(table.getLayout().isPresent(), "tableLayout must be present when currentConstraint or enforcedConstraint is non-trivial");
        }
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public boolean isTemporaryTable() {
        return this.temporaryTable;
    }

    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        TableScanNode.checkState(this.currentConstraint != null, "currentConstraint should only be used in planner. It is not transported to workers.");
        return this.currentConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        TableScanNode.checkState(this.enforcedConstraint != null, "enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("table='").append(this.table).append('\'');
        stringBuilder.append(", outputSymbols='").append(this.outputSymbols).append('\'');
        stringBuilder.append(", assignments='").append(this.assignments).append('\'');
        stringBuilder.append(", currentConstraint='").append(this.currentConstraint).append('\'');
        stringBuilder.append(", enforcedConstraint='").append(this.enforcedConstraint).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        TableScanNode.checkArgument(newChildren.isEmpty(), "newChildren is not empty");
        return this;
    }

    private static void checkArgument(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void checkState(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

