/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticAggregations {
    private final Map<Symbol, AggregationNode.Aggregation> aggregations;
    private final List<Symbol> groupingSymbols;

    @JsonCreator
    public StatisticAggregations(@JsonProperty(value="aggregations") Map<Symbol, AggregationNode.Aggregation> aggregations, @JsonProperty(value="groupingSymbols") List<Symbol> groupingSymbols) {
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        this.groupingSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSymbols, "groupingSymbols is null"));
    }

    @JsonProperty
    public Map<Symbol, AggregationNode.Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty
    public List<Symbol> getGroupingSymbols() {
        return this.groupingSymbols;
    }

    public Parts createPartialAggregations(SymbolAllocator symbolAllocator, FunctionManager functionManager) {
        ImmutableMap.Builder partialAggregation = ImmutableMap.builder();
        ImmutableMap.Builder finalAggregation = ImmutableMap.builder();
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : this.aggregations.entrySet()) {
            AggregationNode.Aggregation originalAggregation = entry.getValue();
            FunctionHandle functionHandle = originalAggregation.getFunctionHandle();
            InternalAggregationFunction function = functionManager.getAggregateFunctionImplementation(functionHandle);
            Symbol partialSymbol = symbolAllocator.newSymbol(functionManager.getFunctionMetadata(functionHandle).getName(), function.getIntermediateType());
            mappings.put((Object)entry.getKey(), (Object)partialSymbol);
            partialAggregation.put((Object)partialSymbol, (Object)new AggregationNode.Aggregation(functionHandle, originalAggregation.getArguments(), originalAggregation.getFilter(), originalAggregation.getOrderBy(), originalAggregation.isDistinct(), originalAggregation.getMask()));
            finalAggregation.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(functionHandle, (List<Expression>)ImmutableList.of((Object)partialSymbol.toSymbolReference()), Optional.empty(), Optional.empty(), false, Optional.empty()));
        }
        this.groupingSymbols.forEach(symbol -> mappings.put(symbol, symbol));
        return new Parts(new StatisticAggregations((Map<Symbol, AggregationNode.Aggregation>)partialAggregation.build(), this.groupingSymbols), new StatisticAggregations((Map<Symbol, AggregationNode.Aggregation>)finalAggregation.build(), this.groupingSymbols), (Map<Symbol, Symbol>)mappings.build());
    }

    public static class Parts {
        private final StatisticAggregations partialAggregation;
        private final StatisticAggregations finalAggregation;
        private final Map<Symbol, Symbol> mappings;

        public Parts(StatisticAggregations partialAggregation, StatisticAggregations finalAggregation, Map<Symbol, Symbol> mappings) {
            this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
            this.finalAggregation = Objects.requireNonNull(finalAggregation, "finalAggregation is null");
            this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
        }

        public StatisticAggregations getPartialAggregation() {
            return this.partialAggregation;
        }

        public StatisticAggregations getFinalAggregation() {
            return this.finalAggregation;
        }

        public Map<Symbol, Symbol> getMappings() {
            return this.mappings;
        }
    }
}

