/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class SortNode
extends InternalPlanNode {
    private final PlanNode source;
    private final OrderingScheme orderingScheme;

    @JsonCreator
    public SortNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="orderingScheme") OrderingScheme orderingScheme) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.source = source;
        this.orderingScheme = orderingScheme;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty(value="orderingScheme")
    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SortNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme);
    }
}

