/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class SetOperationNode
extends InternalPlanNode {
    private final List<PlanNode> sources;
    private final ListMultimap<Symbol, Symbol> outputToInputs;
    private final List<Symbol> outputs;

    @JsonCreator
    protected SetOperationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputToInputs") ListMultimap<Symbol, Symbol> outputToInputs, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        Objects.requireNonNull(sources, "sources is null");
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source");
        Objects.requireNonNull(outputToInputs, "outputToInputs is null");
        Objects.requireNonNull(outputs, "outputs is null");
        this.sources = ImmutableList.copyOf(sources);
        this.outputToInputs = ImmutableListMultimap.copyOf(outputToInputs);
        this.outputs = ImmutableList.copyOf(outputs);
        for (Collection inputs : this.outputToInputs.asMap().values()) {
            Preconditions.checkArgument((inputs.size() == this.sources.size() ? 1 : 0) != 0, (String)"Every source needs to map its symbols to an output %s operation symbol", (Object)this.getClass().getSimpleName());
        }
        for (int i = 0; i < sources.size(); ++i) {
            for (Collection expectedInputs : this.outputToInputs.asMap().values()) {
                Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().contains(Iterables.get((Iterable)expectedInputs, (int)i)), (Object)"Source does not provide required symbols");
            }
        }
    }

    @Override
    @JsonProperty(value="sources")
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty(value="outputToInputs")
    public ListMultimap<Symbol, Symbol> getSymbolMapping() {
        return this.outputToInputs;
    }

    public List<Symbol> sourceOutputLayout(int sourceIndex) {
        return (List)this.getOutputSymbols().stream().map(symbol -> (Symbol)this.outputToInputs.get(symbol).get(sourceIndex)).collect(ImmutableList.toImmutableList());
    }

    public Map<Symbol, Symbol> sourceSymbolMap(int sourceIndex) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.outputToInputs.asMap().entrySet()) {
            builder.put(entry.getKey(), Iterables.get((Iterable)((Iterable)entry.getValue()), (int)sourceIndex));
        }
        return builder.build();
    }

    public Multimap<Symbol, Symbol> outputSymbolMap(int sourceIndex) {
        return FluentIterable.from(this.getOutputSymbols()).toMap(outputSymbol -> (Symbol)this.outputToInputs.get(outputSymbol).get(sourceIndex)).asMultimap().inverse();
    }
}

