/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SemiJoinNode
extends InternalPlanNode {
    private final PlanNode source;
    private final PlanNode filteringSource;
    private final Symbol sourceJoinSymbol;
    private final Symbol filteringSourceJoinSymbol;
    private final Symbol semiJoinOutput;
    private final Optional<Symbol> sourceHashSymbol;
    private final Optional<Symbol> filteringSourceHashSymbol;
    private final Optional<DistributionType> distributionType;

    @JsonCreator
    public SemiJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="filteringSource") PlanNode filteringSource, @JsonProperty(value="sourceJoinSymbol") Symbol sourceJoinSymbol, @JsonProperty(value="filteringSourceJoinSymbol") Symbol filteringSourceJoinSymbol, @JsonProperty(value="semiJoinOutput") Symbol semiJoinOutput, @JsonProperty(value="sourceHashSymbol") Optional<Symbol> sourceHashSymbol, @JsonProperty(value="filteringSourceHashSymbol") Optional<Symbol> filteringSourceHashSymbol, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.filteringSource = Objects.requireNonNull(filteringSource, "filteringSource is null");
        this.sourceJoinSymbol = Objects.requireNonNull(sourceJoinSymbol, "sourceJoinSymbol is null");
        this.filteringSourceJoinSymbol = Objects.requireNonNull(filteringSourceJoinSymbol, "filteringSourceJoinSymbol is null");
        this.semiJoinOutput = Objects.requireNonNull(semiJoinOutput, "semiJoinOutput is null");
        this.sourceHashSymbol = Objects.requireNonNull(sourceHashSymbol, "sourceHashSymbol is null");
        this.filteringSourceHashSymbol = Objects.requireNonNull(filteringSourceHashSymbol, "filteringSourceHashSymbol is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(sourceJoinSymbol), (Object)"Source does not contain join symbol");
        Preconditions.checkArgument((boolean)filteringSource.getOutputSymbols().contains(filteringSourceJoinSymbol), (Object)"Filtering source does not contain filtering join symbol");
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="filteringSource")
    public PlanNode getFilteringSource() {
        return this.filteringSource;
    }

    @JsonProperty(value="sourceJoinSymbol")
    public Symbol getSourceJoinSymbol() {
        return this.sourceJoinSymbol;
    }

    @JsonProperty(value="filteringSourceJoinSymbol")
    public Symbol getFilteringSourceJoinSymbol() {
        return this.filteringSourceJoinSymbol;
    }

    @JsonProperty(value="semiJoinOutput")
    public Symbol getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @JsonProperty(value="sourceHashSymbol")
    public Optional<Symbol> getSourceHashSymbol() {
        return this.sourceHashSymbol;
    }

    @JsonProperty(value="filteringSourceHashSymbol")
    public Optional<Symbol> getFilteringSourceHashSymbol() {
        return this.filteringSourceHashSymbol;
    }

    @JsonProperty(value="distributionType")
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source, (Object)this.filteringSource);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.semiJoinOutput).build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SemiJoinNode(this.getId(), newChildren.get(0), newChildren.get(1), this.sourceJoinSymbol, this.filteringSourceJoinSymbol, this.semiJoinOutput, this.sourceHashSymbol, this.filteringSourceHashSymbol, this.distributionType);
    }

    public SemiJoinNode withDistributionType(DistributionType distributionType) {
        return new SemiJoinNode(this.getId(), this.source, this.filteringSource, this.sourceJoinSymbol, this.filteringSourceJoinSymbol, this.semiJoinOutput, this.sourceHashSymbol, this.filteringSourceHashSymbol, Optional.of(distributionType));
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

