/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RemoteSourceNode
extends InternalPlanNode {
    private final List<PlanFragmentId> sourceFragmentIds;
    private final List<Symbol> outputs;
    private final Optional<OrderingScheme> orderingScheme;
    private final ExchangeNode.Type exchangeType;

    @JsonCreator
    public RemoteSourceNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sourceFragmentIds") List<PlanFragmentId> sourceFragmentIds, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="exchangeType") ExchangeNode.Type exchangeType) {
        super(id);
        Objects.requireNonNull(outputs, "outputs is null");
        this.sourceFragmentIds = sourceFragmentIds;
        this.outputs = ImmutableList.copyOf(outputs);
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType is null");
    }

    public RemoteSourceNode(PlanNodeId id, PlanFragmentId sourceFragmentId, List<Symbol> outputs, Optional<OrderingScheme> orderingScheme, ExchangeNode.Type exchangeType) {
        this(id, (List<PlanFragmentId>)ImmutableList.of((Object)sourceFragmentId), outputs, orderingScheme, exchangeType);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty(value="sourceFragmentIds")
    public List<PlanFragmentId> getSourceFragmentIds() {
        return this.sourceFragmentIds;
    }

    @JsonProperty(value="orderingScheme")
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty(value="exchangeType")
    public ExchangeNode.Type getExchangeType() {
        return this.exchangeType;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitRemoteSource(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

