/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FilterNode
extends PlanNode {
    private final PlanNode source;
    private final RowExpression predicate;

    @JsonCreator
    public FilterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="predicate") RowExpression predicate) {
        super(id);
        this.source = source;
        this.predicate = predicate;
    }

    @JsonProperty(value="predicate")
    public RowExpression getPredicate() {
        return this.predicate;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.singletonList(this.source));
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        if (newChildren == null || newChildren.size() != 1) {
            throw new IllegalArgumentException("Expect exactly one child to replace");
        }
        return new FilterNode(this.getId(), newChildren.get(0), this.predicate);
    }
}

