/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AggregationNodeUtils {
    private AggregationNodeUtils() {
    }

    public static AggregationNode.Aggregation count(FunctionManager functionManager) {
        return new AggregationNode.Aggregation(new FunctionResolution(functionManager).countFunction(), (List<Expression>)ImmutableList.of(), Optional.empty(), Optional.empty(), false, Optional.empty());
    }

    public static Set<Symbol> extractUnique(AggregationNode.Aggregation aggregation) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        aggregation.getArguments().forEach(argument -> builder.addAll(SymbolsExtractor.extractAll(argument)));
        aggregation.getFilter().ifPresent(filter -> builder.addAll(SymbolsExtractor.extractAll(filter)));
        aggregation.getOrderBy().ifPresent(orderingScheme -> builder.addAll(orderingScheme.getOrderBy()));
        return builder.build();
    }
}

