/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SingleDistinctAggregationToGroupBy
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(SingleDistinctAggregationToGroupBy::hasSingleDistinctInput).matching(SingleDistinctAggregationToGroupBy::allDistinctAggregates).matching(SingleDistinctAggregationToGroupBy::noFilters).matching(SingleDistinctAggregationToGroupBy::noMasks);

    private static boolean hasSingleDistinctInput(AggregationNode aggregation) {
        return SingleDistinctAggregationToGroupBy.extractArgumentSets(aggregation).count() == 1L;
    }

    private static boolean allDistinctAggregates(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().allMatch(AggregationNode.Aggregation::isDistinct);
    }

    private static boolean noFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().noneMatch(instance -> instance.getFilter().isPresent());
    }

    private static boolean noMasks(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().noneMatch(e -> e.getMask().isPresent());
    }

    private static Stream<Set<Expression>> extractArgumentSets(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().filter(AggregationNode.Aggregation::isDistinct).map(AggregationNode.Aggregation::getArguments).map(HashSet::new).distinct();
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregation, Captures captures, Rule.Context context) {
        List argumentSets = SingleDistinctAggregationToGroupBy.extractArgumentSets(aggregation).collect(Collectors.toList());
        Set symbols = ((Set)Iterables.getOnlyElement(argumentSets)).stream().map(Symbol::from).collect(Collectors.toSet());
        return Rule.Result.ofPlanNode(new AggregationNode(aggregation.getId(), new AggregationNode(context.getIdAllocator().getNextId(), aggregation.getSource(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.builder().addAll(aggregation.getGroupingKeys()).addAll(symbols).build()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), aggregation.getAggregations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SingleDistinctAggregationToGroupBy.removeDistinct((AggregationNode.Aggregation)e.getValue()))), aggregation.getGroupingSets(), Collections.emptyList(), aggregation.getStep(), aggregation.getHashSymbol(), aggregation.getGroupIdSymbol()));
    }

    private static AggregationNode.Aggregation removeDistinct(AggregationNode.Aggregation aggregation) {
        Preconditions.checkArgument((boolean)aggregation.isDistinct(), (Object)"Expected aggregation to have DISTINCT input");
        return new AggregationNode.Aggregation(aggregation.getFunctionHandle(), aggregation.getArguments(), aggregation.getFilter(), aggregation.getOrderBy(), false, aggregation.getMask());
    }
}

