/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SimplifyCountOverConstant
implements Rule<AggregationNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final StandardFunctionResolution functionResolution;

    public SimplifyCountOverConstant(FunctionManager functionManager) {
        Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionManager);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        boolean changed = false;
        LinkedHashMap<Symbol, AggregationNode.Aggregation> aggregations = new LinkedHashMap<Symbol, AggregationNode.Aggregation>(parent.getAggregations());
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : parent.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!this.isCountOverConstant(aggregation, child.getAssignments())) continue;
            changed = true;
            aggregations.put(symbol, new AggregationNode.Aggregation(this.functionResolution.countFunction(), (List<Expression>)ImmutableList.of(), Optional.empty(), Optional.empty(), false, aggregation.getMask()));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(parent.getId(), child, aggregations, parent.getGroupingSets(), (List<Symbol>)ImmutableList.of(), parent.getStep(), parent.getHashSymbol(), parent.getGroupIdSymbol()));
    }

    private boolean isCountOverConstant(AggregationNode.Aggregation aggregation, Assignments inputs) {
        if (!this.functionResolution.isCountFunction(aggregation.getFunctionHandle()) || aggregation.getArguments().size() != 1) {
            return false;
        }
        Expression argument = aggregation.getArguments().get(0);
        if (argument instanceof SymbolReference) {
            argument = inputs.get(Symbol.from(argument));
        }
        return argument instanceof Literal && !(argument instanceof NullLiteral);
    }
}

