/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class PruneSemiJoinFilteringSourceColumns
implements Rule<SemiJoinNode> {
    private static final Pattern<SemiJoinNode> PATTERN = Patterns.semiJoin();

    @Override
    public Pattern<SemiJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SemiJoinNode semiJoinNode, Captures captures, Rule.Context context) {
        Set requiredFilteringSourceInputs = (Set)Streams.concat((Stream[])new Stream[]{Stream.of(semiJoinNode.getFilteringSourceJoinSymbol()), semiJoinNode.getFilteringSourceHashSymbol().map(Stream::of).orElse(Stream.empty())}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictOutputs(context.getIdAllocator(), semiJoinNode.getFilteringSource(), requiredFilteringSourceInputs).map(newFilteringSource -> semiJoinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)semiJoinNode.getSource(), (Object)newFilteringSource))).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

