/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PruneCountAggregationOverScalar
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final StandardFunctionResolution functionResolution;

    public PruneCountAggregationOverScalar(FunctionManager functionManager) {
        Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionManager);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        if (!parent.hasDefaultOutput() || parent.getOutputSymbols().size() != 1) {
            return Rule.Result.empty();
        }
        Map<Symbol, AggregationNode.Aggregation> assignments = parent.getAggregations();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            Objects.requireNonNull(aggregation, "aggregation is null");
            if (this.functionResolution.isCountFunction(aggregation.getFunctionHandle()) && aggregation.getArguments().isEmpty()) continue;
            return Rule.Result.empty();
        }
        if (!assignments.isEmpty() && QueryCardinalityUtil.isScalar(parent.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(parent.getId(), parent.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant(1L, (Type)BigintType.BIGINT)))));
        }
        return Rule.Result.empty();
    }
}

