/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Stream;

public class PruneAggregationSourceColumns
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{aggregationNode.getGroupingKeys().stream(), aggregationNode.getHashSymbol().map(Stream::of).orElse(Stream.empty()), aggregationNode.getAggregations().values().stream().flatMap(PruneAggregationSourceColumns::getAggregationInputs)}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), aggregationNode, requiredInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    private static Stream<Symbol> getAggregationInputs(AggregationNode.Aggregation aggregation) {
        return Streams.concat((Stream[])new Stream[]{AggregationNodeUtils.extractUnique(aggregation).stream(), aggregation.getMask().map(Stream::of).orElse(Stream.empty())});
    }
}

