/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Plans {
    public static PlanNode resolveGroupReferences(PlanNode node, Lookup lookup) {
        Objects.requireNonNull(node, "node is null");
        return node.accept(new ResolvingVisitor(lookup), null);
    }

    private Plans() {
    }

    private static class ResolvingVisitor
    extends InternalPlanVisitor<PlanNode, Void> {
        private final Lookup lookup;

        public ResolvingVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, Void context) {
            List<PlanNode> children = node.getSources().stream().map(child -> child.accept(this, context)).collect(Collectors.toList());
            return node.replaceChildren(children);
        }

        @Override
        public PlanNode visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }
    }
}

