/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.Coercer;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.SampleNodeUtil;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, metadata, session);
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            Type[] types = (Type[])scope.getRelationType().getAllFields().stream().map(Field::getType).toArray(Type[]::new);
            RelationPlan withCoercions = this.addCoercions(subPlan, types);
            return new RelationPlan(withCoercions.getRoot(), scope, withCoercions.getFieldMappings());
        }
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : scope.getRelationType().getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        TableScanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)columns.build());
        return new RelationPlan(root, scope, (List<Symbol>)outputSymbols);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                Field field = subPlan.getDescriptor().getFieldByIndex(i);
                if (field.isHidden()) continue;
                Symbol aliasedColumn = this.symbolAllocator.newSymbol(field);
                assignments.put(aliasedColumn, (Expression)subPlan.getFieldMappings().get(i).toSymbolReference());
                newMappings.add((Object)aliasedColumn);
            }
            root = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build());
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)mappings);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNodeUtil.fromType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings());
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        ImmutableList outputSymbols;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        block23: {
            RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
            Optional<Unnest> unnest = this.getUnnest(node.getRight());
            if (unnest.isPresent()) {
                if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                    throw SemanticExceptions.notSupportedException((Node)unnest.get(), "UNNEST on other than the right side of CROSS JOIN");
                }
                return this.planCrossJoinUnnest(leftPlan, node, unnest.get());
            }
            Optional<Lateral> lateral = this.getLateral(node.getRight());
            if (lateral.isPresent()) {
                if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                    throw SemanticExceptions.notSupportedException((Node)lateral.get(), "LATERAL on other than the right side of CROSS JOIN");
                }
                return this.planLateralJoin(node, leftPlan, lateral.get());
            }
            RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
            if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
                return this.planJoinUsing(node, leftPlan, rightPlan);
            }
            leftPlanBuilder = this.initializePlanBuilder(leftPlan);
            rightPlanBuilder = this.initializePlanBuilder(rightPlan);
            outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) break block23;
            Expression criteria = this.analysis.getJoinCriteria(node);
            RelationType left = this.analysis.getOutputDescriptor((Node)node.getLeft());
            RelationType right = this.analysis.getOutputDescriptor((Node)node.getRight());
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                block25: {
                    block24: {
                        if (!RelationPlanner.isEqualComparisonExpression(conjunct = ExpressionUtils.normalize(conjunct)) && node.getType() != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = SymbolsExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block24;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block25;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = SymbolsExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = SymbolsExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, (Node)node);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, (Node)node);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.symbolAllocator, this.idAllocator);
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    Symbol leftSymbol = leftPlanBuilder.translate((Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightPlanBuilder.translate((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftComparisonExpressions.get(i));
                Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightComparisonExpressions.get(i));
                postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), leftExpression, rightExpression));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<Symbol>)ImmutableList.builder().addAll(leftPlanBuilder.getRoot().getOutputSymbols()).addAll(rightPlanBuilder.getRoot().getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        if (node.getType() != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<InPredicate> inPredicates = this.subqueryPlanner.collectInPredicateSubqueries(complexExpression, (Node)node);
                if (inPredicates.isEmpty()) continue;
                InPredicate inPredicate = (InPredicate)Iterables.getLast(inPredicates);
                throw SemanticExceptions.notSupportedException((Node)inPredicate, "IN with subquery predicate in join condition");
            }
            leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, complexJoinExpressions, (Node)node);
        }
        RelationPlan intermediateRootRelationPlan = new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols);
        TranslationMap translationMap = new TranslationMap(intermediateRootRelationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translationMap.setFieldMappings((List<Symbol>)outputSymbols);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        if (node.getType() != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            Expression rewrittenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<Symbol>)ImmutableList.builder().addAll(leftPlanBuilder.getRoot().getOutputSymbols()).addAll(rightPlanBuilder.getRoot().getOutputSymbols()).build(), Optional.of(OriginalExpressionUtils.castToRowExpression(rewrittenFilterCondition)), Optional.empty(), Optional.empty(), Optional.empty());
        }
        if (node.getType() == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root, this.analysis.getParameters());
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, (Node)node);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), root, OriginalExpressionUtils.castToRowExpression(postInnerJoinCriteria));
            }
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols);
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        Symbol symbol;
        List joinColumns = ((JoinUsing)node.getCriteria().get()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, Symbol> leftJoinColumns = new HashMap<Identifier, Symbol>();
        HashMap<Identifier, Symbol> rightJoinColumns = new HashMap<Identifier, Symbol>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putIdentities(left.getRoot().getOutputSymbols());
        rightCoercions.putIdentities(right.getRoot().getOutputSymbols());
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((Expression)identifier);
            Symbol leftOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, (Expression)new Cast((Expression)left.getSymbol(leftField).toSymbolReference(), type.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(left.getDescriptor().getFieldByIndex(leftField).getType(), type)));
            leftJoinColumns.put(identifier, leftOutput);
            Symbol rightOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, (Expression)new Cast((Expression)right.getSymbol(rightField).toSymbolReference(), type.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(right.getDescriptor().getFieldByIndex(rightField).getType(), type)));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftCoercion, rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), (List<Symbol>)ImmutableList.builder().addAll(leftCoercion.getOutputSymbols()).addAll(rightCoercion.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            Symbol output = this.symbolAllocator.newSymbol((Expression)column, this.analysis.getType((Expression)column));
            outputs.add((Object)output);
            assignments.put(output, (Expression)new CoalesceExpression((Expression)((Symbol)leftJoinColumns.get(column)).toSymbolReference(), (Expression)((Symbol)rightJoinColumns.get(column)).toSymbolReference(), new Expression[0]));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = left.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = right.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        return new RelationPlan(new ProjectNode(this.idAllocator.getNextId(), join, assignments.build()), this.analysis.getScope((Node)node), (List<Symbol>)outputs.build());
    }

    private Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planLateralJoin(Join join, RelationPlan leftPlan, Lateral lateral) {
        RelationPlan rightPlan = (RelationPlan)this.process((Node)lateral.getQuery(), null);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        PlanBuilder planBuilder = this.subqueryPlanner.appendLateralJoin(leftPlanBuilder, rightPlanBuilder, lateral.getQuery(), true, LateralJoinNode.Type.INNER);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getRoot().getOutputSymbols()).addAll(rightPlan.getRoot().getOutputSymbols()).build();
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<Symbol>)outputSymbols);
    }

    private static boolean isEqualComparisonExpression(Expression conjunct) {
        return conjunct instanceof ComparisonExpression && ((ComparisonExpression)conjunct).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    private RelationPlan planCrossJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedSymbolsBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            unnestedSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = unnestedSymbolsBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = planBuilder.appendProjections(node.getExpressions(), this.symbolAllocator, this.idAllocator);
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = (ProjectNode)planBuilder.getRoot();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        UnmodifiableIterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Symbol inputSymbol = translations.get(expression);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    ImmutableList.Builder unnestSymbolBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestSymbolBuilder.add(unnestedSymbolsIterator.next());
                    }
                    unnestSymbols.put((Object)inputSymbol, (Object)unnestSymbolBuilder.build());
                    continue;
                }
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next(), (Object)unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), projectNode, leftPlan.getFieldMappings(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, this.analysis.getScope((Node)joinNode), unnestNode.getOutputSymbols());
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                for (Expression item : ((Row)row).getItems()) {
                    Expression expression = Coercer.addCoercions(item, this.analysis);
                    values.add((Object)OriginalExpressionUtils.castToRowExpression(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression)));
                }
            } else {
                Expression expression = Coercer.addCoercions(row, this.analysis);
                values.add((Object)OriginalExpressionUtils.castToRowExpression(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression)));
            }
            rowsBuilder.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbolsBuilder.build(), (List<List<RowExpression>>)rowsBuilder.build());
        return new RelationPlan(valuesNode, scope, (List<Symbol>)outputSymbolsBuilder.build());
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = outputSymbolsBuilder.build();
        ImmutableList.Builder argumentSymbols = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        Iterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Expression rewritten = Coercer.addCoercions(expression, this.analysis);
            rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)rewritten);
            values.add((Object)OriginalExpressionUtils.castToRowExpression(rewritten));
            Symbol inputSymbol = this.symbolAllocator.newSymbol(rewritten, type);
            argumentSymbols.add((Object)inputSymbol);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    ImmutableList.Builder unnestSymbolBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestSymbolBuilder.add(unnestedSymbolsIterator.next());
                    }
                    unnestSymbols.put((Object)inputSymbol, (Object)unnestSymbolBuilder.build());
                    continue;
                }
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next(), unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)argumentSymbols.build(), (List<List<RowExpression>>)ImmutableList.of((Object)values.build()));
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), valuesNode, (List<Symbol>)ImmutableList.of(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol);
        return new RelationPlan(unnestNode, scope, (List<Symbol>)unnestedSymbols);
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, Void context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = (RelationPlan)this.process((Node)node, context);
        if (coerceToTypes == null) {
            return plan;
        }
        return this.addCoercions(plan, coerceToTypes);
    }

    private RelationPlan addCoercions(RelationPlan plan, Type[] targetColumnTypes) {
        List<Symbol> oldSymbols = plan.getFieldMappings();
        RelationType oldDescriptor = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((targetColumnTypes.length == oldSymbols.size() ? 1 : 0) != 0);
        ImmutableList.Builder newSymbols = new ImmutableList.Builder();
        Field[] newFields = new Field[targetColumnTypes.length];
        Assignments.Builder assignments = Assignments.builder();
        for (int i = 0; i < targetColumnTypes.length; ++i) {
            Symbol outputSymbol;
            Symbol inputSymbol = oldSymbols.get(i);
            Type outputType = targetColumnTypes[i];
            Type inputType = this.symbolAllocator.getTypes().get(inputSymbol);
            if (!outputType.equals(inputType)) {
                Cast cast = new Cast((Expression)inputSymbol.toSymbolReference(), outputType.getTypeSignature().toString());
                outputSymbol = this.symbolAllocator.newSymbol((Expression)cast, outputType);
                assignments.put(outputSymbol, (Expression)cast);
                newSymbols.add((Object)outputSymbol);
            } else {
                SymbolReference symbolReference = inputSymbol.toSymbolReference();
                outputSymbol = this.symbolAllocator.newSymbol((Expression)symbolReference, outputType);
                assignments.put(outputSymbol, (Expression)symbolReference);
                newSymbols.add((Object)outputSymbol);
            }
            Field oldField = oldDescriptor.getFieldByIndex(i);
            newFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), targetColumnTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        return new RelationPlan(projectNode, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(newFields)).build(), (List<Symbol>)newSymbols.build());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), planNode.getOutputSymbols());
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols());
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols());
    }

    private SetOperationPlan process(SetOperation node) {
        List outputs = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, null)).collect(ImmutableList.toImmutableList());
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            List<Symbol> childOutputSymbols = relationPlan.getFieldMappings();
            if (outputs == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    Symbol symbol = childOutputSymbols.get(fieldIndex);
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                outputs = outputSymbolBuilder.build();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == outputs.size() ? 1 : 0) != 0, (String)"Expected relation to have %s symbols but has %s symbols", (int)descriptor.getVisibleFieldCount(), (int)outputs.size());
            int fieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                symbolMapping.put(outputs.get(fieldId), (Object)childOutputSymbols.get(fieldIndex));
                ++fieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        return new SetOperationPlan((List)sources.build(), (ListMultimap)symbolMapping.build());
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getOutputSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
    }

    private static class SetOperationPlan {
        private final List<PlanNode> sources;
        private final ListMultimap<Symbol, Symbol> symbolMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<Symbol, Symbol> symbolMapping) {
            this.sources = sources;
            this.symbolMapping = symbolMapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public ListMultimap<Symbol, Symbol> getSymbolMapping() {
            return this.symbolMapping;
        }
    }
}

