/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;

public class PlannerUtils {
    private PlannerUtils() {
    }

    public static SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }

    public static OrderingScheme toOrderingScheme(List<SortItem> sortItems) {
        return PlannerUtils.toOrderingScheme(sortItems, item -> {
            Preconditions.checkArgument((boolean)(item instanceof SymbolReference), (Object)"must be symbol reference");
            return new Symbol(((SymbolReference)item).getName());
        });
    }

    public static OrderingScheme toOrderingScheme(List<SortItem> sortItems, Function<Expression, Symbol> translator) {
        LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
        for (SortItem item : sortItems) {
            Symbol symbol = translator.apply(item.getSortKey());
            orderings.putIfAbsent(symbol, PlannerUtils.toSortOrder(item));
        }
        return new OrderingScheme((List)orderings.keySet().stream().collect(ImmutableList.toImmutableList()), orderings);
    }

    public static OrderingScheme toOrderingScheme(OrderBy orderBy) {
        return PlannerUtils.toOrderingScheme(orderBy.getSortItems());
    }
}

