/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final PartitioningHandle partitioning;
    private final List<PlanNodeId> tableScanSchedulingOrder;
    private final List<Type> types;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final PartitioningScheme partitioningScheme;
    private final StageExecutionDescriptor stageExecutionDescriptor;
    private final boolean materializedExchangeSource;
    private final StatsAndCosts statsAndCosts;
    private final Optional<String> jsonRepresentation;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="tableScanSchedulingOrder") List<PlanNodeId> tableScanSchedulingOrder, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="stageExecutionDescriptor") StageExecutionDescriptor stageExecutionDescriptor, @JsonProperty(value="materializedExchangeSource") boolean materializedExchangeSource, @JsonProperty(value="statsAndCosts") StatsAndCosts statsAndCosts, @JsonProperty(value="jsonRepresentation") Optional<String> jsonRepresentation) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.tableScanSchedulingOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableScanSchedulingOrder, "tableScanSchedulingOrder is null"));
        this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
        this.materializedExchangeSource = materializedExchangeSource;
        this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.jsonRepresentation = Objects.requireNonNull(jsonRepresentation, "jsonRepresentation is null");
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(partitioningScheme.getOutputLayout()), (String)"Root node outputs (%s) does not include all fragment outputs (%s)", root.getOutputSymbols(), partitioningScheme.getOutputLayout());
        this.types = (List)partitioningScheme.getOutputLayout().stream().map(symbols::get).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<PlanNodeId> getTableScanSchedulingOrder() {
        return this.tableScanSchedulingOrder;
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public StageExecutionDescriptor getStageExecutionDescriptor() {
        return this.stageExecutionDescriptor;
    }

    @JsonProperty
    public boolean isMaterializedExchangeSource() {
        return this.materializedExchangeSource;
    }

    @JsonProperty
    public StatsAndCosts getStatsAndCosts() {
        return this.statsAndCosts;
    }

    @JsonProperty
    public Optional<String> getJsonRepresentation() {
        return this.jsonRepresentation;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static Set<PlanNode> findSources(PlanNode node, Iterable<PlanNodeId> nodeIds) {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        PlanFragment.findSources(node, (Set<PlanNodeId>)ImmutableSet.copyOf(nodeIds), (ImmutableSet.Builder<PlanNode>)nodes);
        return nodes.build();
    }

    private static void findSources(PlanNode node, Set<PlanNodeId> nodeIds, ImmutableSet.Builder<PlanNode> nodes) {
        if (nodeIds.contains(node.getId())) {
            nodes.add((Object)node);
        }
        for (PlanNode source : node.getSources()) {
            nodes.addAll(PlanFragment.findSources(source, nodeIds));
        }
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public PlanFragment withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme.withBucketToPartition(bucketToPartition), this.stageExecutionDescriptor, this.materializedExchangeSource, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withFixedLifespanScheduleGroupedExecution(List<PlanNodeId> capableTableScanNodes) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, StageExecutionDescriptor.fixedLifespanScheduleGroupedExecution(capableTableScanNodes), this.materializedExchangeSource, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withDynamicLifespanScheduleGroupedExecution(List<PlanNodeId> capableTableScanNodes) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, StageExecutionDescriptor.dynamicLifespanScheduleGroupedExecution(capableTableScanNodes), this.materializedExchangeSource, this.statsAndCosts, this.jsonRepresentation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitioning", (Object)this.partitioning).add("tableScanSchedulingOrder", this.tableScanSchedulingOrder).add("partitionFunction", (Object)this.partitioningScheme).toString();
    }
}

