/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LogicalPlanner {
    private final boolean explain;
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanSanityChecker planSanityChecker;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final WarningCollector warningCollector;

    public LogicalPlanner(boolean explain, Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this(explain, session, planOptimizers, PlanSanityChecker.DISTRIBUTED_PLAN_SANITY_CHECKER, idAllocator, metadata, sqlParser, statsCalculator, costCalculator, warningCollector);
    }

    public LogicalPlanner(boolean explain, Session session, List<PlanOptimizer> planOptimizers, PlanSanityChecker planSanityChecker, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this.explain = explain;
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planSanityChecker = Objects.requireNonNull(planSanityChecker, "planSanityChecker is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(session, this.symbolAllocator, metadata);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Plan plan(Analysis analysis) {
        return this.plan(analysis, Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan plan(Analysis analysis, Stage stage) {
        PlanNode root = this.planStatement(analysis, analysis.getStatement());
        this.planSanityChecker.validateIntermediatePlan(root, this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), this.warningCollector);
        if (stage.ordinal() >= Stage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
            }
        }
        if (stage.ordinal() >= Stage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planSanityChecker.validateFinalPlan(root, this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), this.warningCollector);
        }
        TypeProvider types = this.symbolAllocator.getTypes();
        return new Plan(root, types, this.computeStats(root, types));
    }

    private StatsAndCosts computeStats(PlanNode root, TypeProvider types) {
        if (this.explain || SystemSessionProperties.isPrintStatsForNonJoinQuery(this.session) || PlanNodeSearcher.searchFrom(root).where(node -> node instanceof JoinNode || node instanceof SemiJoinNode).matches()) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session, types);
            return StatsAndCosts.create(root, statsProvider, costProvider);
        }
        return StatsAndCosts.empty();
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.isCreateTableAsSelectNoOp()) {
            Preconditions.checkState((boolean)analysis.getCreateTableDestination().isPresent(), (Object)"Table destination is missing");
            Symbol symbol = this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of((Object)symbol), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant(0L, (Type)BigintType.BIGINT))));
            return new OutputNode(this.idAllocator.getNextId(), source, (List<String>)ImmutableList.of((Object)"rows"), (List<Symbol>)ImmutableList.of((Object)symbol));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.isCreateTableAsSelectNoOp()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Analyze) {
            return this.createAnalyzePlan(analysis, (Analyze)statement);
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze()) {
            return this.createExplainAnalyzePlan(analysis, (Explain)statement);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, Explain statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        Symbol outputSymbol = this.symbolAllocator.newSymbol(scope.getRelationType().getFieldByIndex(0));
        root = new ExplainAnalyzeNode(this.idAllocator.getNextId(), root, outputSymbol, statement.isVerbose());
        return new RelationPlan(root, scope, (List<Symbol>)ImmutableList.of((Object)outputSymbol));
    }

    private RelationPlan createAnalyzePlan(Analysis analysis, Analyze analyzeStatement) {
        TableHandle targetTable = analysis.getAnalyzeTarget().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTable);
        ImmutableList.Builder tableScanOutputs = ImmutableList.builder();
        ImmutableMap.Builder symbolToColumnHandle = ImmutableMap.builder();
        ImmutableMap.Builder columnNameToSymbol = ImmutableMap.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTable);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Symbol symbol = this.symbolAllocator.newSymbol(column.getName(), column.getType());
            tableScanOutputs.add((Object)symbol);
            symbolToColumnHandle.put((Object)symbol, (Object)columnHandles.get(column.getName()));
            columnNameToSymbol.put((Object)column.getName(), (Object)symbol);
        }
        TableStatisticsMetadata tableStatisticsMetadata = this.metadata.getStatisticsCollectionMetadata(this.session, targetTable.getConnectorId().getCatalogName(), tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation tableStatisticAggregation = this.statisticsAggregationPlanner.createStatisticsAggregation(tableStatisticsMetadata, (Map<String, Symbol>)columnNameToSymbol.build());
        StatisticAggregations statisticAggregations = tableStatisticAggregation.getAggregations();
        List<Symbol> groupingSymbols = statisticAggregations.getGroupingSymbols();
        StatisticsWriterNode planNode = new StatisticsWriterNode(this.idAllocator.getNextId(), new AggregationNode(this.idAllocator.getNextId(), new TableScanNode(this.idAllocator.getNextId(), targetTable, (List<Symbol>)tableScanOutputs.build(), (Map<Symbol, ColumnHandle>)symbolToColumnHandle.build()), statisticAggregations.getAggregations(), AggregationNode.singleGroupingSet(groupingSymbols), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), new StatisticsWriterNode.WriteStatisticsReference(targetTable), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), tableStatisticsMetadata.getTableStatistics().contains(TableStatisticType.ROW_COUNT), tableStatisticAggregation.getDescriptor());
        return new RelationPlan(planNode, analysis.getScope((Node)analyzeStatement), ((PlanNode)planNode).getOutputSymbols());
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        QualifiedObjectName destination = analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis, query);
        ConnectorTableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan, analysis.getColumnAliases()), analysis.getCreateTableProperties(), analysis.getParameters(), analysis.getCreateTableComment());
        Optional<NewTableLayout> newTableLayout = this.metadata.getNewTableLayout(this.session, destination.getCatalogName(), tableMetadata);
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateName(destination.getCatalogName(), tableMetadata, newTableLayout), columnNames, newTableLayout, statisticsMetadata);
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insert = analysis.getInsert().get();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, insert.getTarget());
        List visibleTableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        List visibleTableColumnNames = (List)visibleTableColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        RelationPlan plan = this.createRelationPlan(analysis, insertStatement.getQuery());
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, insert.getTarget());
        Assignments.Builder assignments = Assignments.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            Symbol output = this.symbolAllocator.newSymbol(column2.getName(), column2.getType());
            int index = insert.getColumns().indexOf(columns.get(column2.getName()));
            if (index < 0) {
                Cast cast = new Cast((Expression)new NullLiteral(), column2.getType().getTypeSignature().toString());
                assignments.put(output, (Expression)cast);
                continue;
            }
            Symbol input = plan.getSymbol(index);
            Type tableType = column2.getType();
            Type queryType = this.symbolAllocator.getTypes().get(input);
            if (queryType.equals(tableType) || this.metadata.getTypeManager().isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, (Expression)input.toSymbolReference());
                continue;
            }
            Cast cast = new Cast((Expression)input.toSymbolReference(), tableType.getTypeSignature().toString());
            assignments.put(output, (Expression)cast);
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        List fields = (List)visibleTableColumns.stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
        plan = new RelationPlan(projectNode, scope, projectNode.getOutputSymbols());
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, insert.getTarget());
        String catalogName = insert.getTarget().getConnectorId().getCatalogName();
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.InsertReference(insert.getTarget()), visibleTableColumnNames, newTableLayout, statisticsMetadata);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, Optional<NewTableLayout> writeTableLayout, TableStatisticsMetadata statisticsMetadata) {
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(this.idAllocator.getNextId(), source, 0L, false);
        }
        writeTableLayout.ifPresent(layout -> {
            if (!ImmutableSet.copyOf((Collection)columnNames).containsAll(layout.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
            }
        });
        List<Symbol> symbols = plan.getFieldMappings();
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        if (writeTableLayout.isPresent()) {
            ArrayList<Symbol> partitionFunctionArguments = new ArrayList<Symbol>();
            writeTableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).forEach(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(writeTableLayout.get().getPartitioning(), partitionFunctionArguments), outputLayout));
        }
        if (!statisticsMetadata.isEmpty()) {
            Verify.verify((columnNames.size() == symbols.size() ? 1 : 0) != 0, (String)"columnNames.size() != symbols.size(): %s and %s", columnNames, symbols);
            Map columnToSymbolMap = (Map)Streams.zip(columnNames.stream(), symbols.stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            StatisticsAggregationPlanner.TableStatisticAggregation result = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnToSymbolMap);
            StatisticAggregations.Parts aggregations = result.getAggregations().createPartialAggregations(this.symbolAllocator, this.metadata.getFunctionManager());
            StatisticAggregations partialAggregation = aggregations.getPartialAggregation();
            TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), this.symbolAllocator.newSymbol("tablecommitcontext", (Type)VarbinaryType.VARBINARY), symbols, columnNames, partitioningScheme, Optional.of(partialAggregation), Optional.of(result.getDescriptor().map(aggregations.getMappings()::get)));
            TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), writerNode, target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.of(aggregations.getFinalAggregation()), Optional.of(result.getDescriptor()));
            return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols());
        }
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), this.symbolAllocator.newSymbol("tablecommitcontext", (Type)VarbinaryType.VARBINARY), symbols, columnNames, partitioningScheme, Optional.empty(), Optional.empty()), target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols());
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        DeleteNode deleteNode = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).plan(node);
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputSymbols());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.metadata, this.session).process((Node)query, null);
    }

    private ConnectorTableMetadata createTableMetadata(QualifiedObjectName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, List<Expression> parameters, Optional<String> comment) {
        ConnectorId connectorId = this.metadata.getCatalogHandle(this.session, table.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + table.getCatalogName()));
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getProperties(connectorId, table.getCatalogName(), propertyExpressions, this.session, this.metadata, parameters);
        return new ConnectorTableMetadata(table.asSchemaTableName(), columns, properties, comment);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan, Optional<List<Identifier>> columnAliases) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int aliasPosition = 0;
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            String columnName = columnAliases.isPresent() ? columnAliases.get().get(aliasPosition).getValue() : field.getName().get();
            columns.add((Object)new ColumnMetadata(columnName, field.getType()));
            ++aliasPosition;
        }
        return columns.build();
    }

    private static Map<NodeRef<LambdaArgumentDeclaration>, Symbol> buildLambdaDeclarationToSymbolMap(Analysis analysis, SymbolAllocator symbolAllocator) {
        LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol> resultMap = new LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol>();
        for (Map.Entry<NodeRef<Expression>, Type> entry : analysis.getTypes().entrySet()) {
            NodeRef lambdaArgumentDeclaration;
            if (!(entry.getKey().getNode() instanceof LambdaArgumentDeclaration) || resultMap.containsKey(lambdaArgumentDeclaration = NodeRef.of((Node)((LambdaArgumentDeclaration)entry.getKey().getNode())))) continue;
            resultMap.put((NodeRef<LambdaArgumentDeclaration>)lambdaArgumentDeclaration, symbolAllocator.newSymbol((Expression)lambdaArgumentDeclaration.getNode(), entry.getValue()));
        }
        return resultMap;
    }

    public static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

