/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ExpressionExtractor {
    public static List<RowExpression> extractExpressions(PlanNode plan) {
        return ExpressionExtractor.extractExpressions(plan, Lookup.noLookup());
    }

    public static List<RowExpression> extractExpressions(PlanNode plan, Lookup lookup) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(lookup, "lookup is null");
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(true, lookup), expressionsBuilder);
        return expressionsBuilder.build();
    }

    public static List<RowExpression> extractExpressionsNonRecursive(PlanNode plan) {
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(false, Lookup.noLookup()), expressionsBuilder);
        return expressionsBuilder.build();
    }

    private ExpressionExtractor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<ImmutableList.Builder<RowExpression>> {
        private final boolean recursive;
        private final Lookup lookup;

        Visitor(boolean recursive, Lookup lookup) {
            this.recursive = recursive;
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected Void visitPlan(PlanNode node, ImmutableList.Builder<RowExpression> context) {
            if (this.recursive) {
                return super.visitPlan(node, context);
            }
            return null;
        }

        @Override
        public Void visitGroupReference(GroupReference node, ImmutableList.Builder<RowExpression> context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, ImmutableList.Builder<RowExpression> context) {
            node.getAggregations().values().forEach(aggregation -> {
                aggregation.getArguments().stream().map(OriginalExpressionUtils::castToRowExpression).forEach(arg_0 -> ((ImmutableList.Builder)context).add(arg_0));
                aggregation.getFilter().map(OriginalExpressionUtils::castToRowExpression).ifPresent(arg_0 -> ((ImmutableList.Builder)context).add(arg_0));
                aggregation.getOrderBy().map(OrderingScheme::getOrderBy).orElse((List)ImmutableList.of()).stream().map(Symbol::toSymbolReference).map(OriginalExpressionUtils::castToRowExpression).forEach(arg_0 -> ((ImmutableList.Builder)context).add(arg_0));
            });
            return (Void)super.visitAggregation(node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, ImmutableList.Builder<RowExpression> context) {
            context.add((Object)node.getPredicate());
            return (Void)super.visitFilter(node, context);
        }

        @Override
        public Void visitProject(ProjectNode node, ImmutableList.Builder<RowExpression> context) {
            context.addAll((Iterable)node.getAssignments().getExpressions().stream().map(OriginalExpressionUtils::castToRowExpression).collect(ImmutableList.toImmutableList()));
            return (Void)super.visitProject(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, ImmutableList.Builder<RowExpression> context) {
            node.getFilter().ifPresent(arg_0 -> context.add(arg_0));
            return (Void)super.visitJoin(node, context);
        }

        @Override
        public Void visitValues(ValuesNode node, ImmutableList.Builder<RowExpression> context) {
            node.getRows().forEach(arg_0 -> context.addAll(arg_0));
            return (Void)super.visitValues(node, context);
        }

        @Override
        public Void visitApply(ApplyNode node, ImmutableList.Builder<RowExpression> context) {
            context.addAll((Iterable)node.getSubqueryAssignments().getExpressions().stream().map(OriginalExpressionUtils::castToRowExpression).collect(ImmutableList.toImmutableList()));
            return (Void)super.visitApply(node, context);
        }
    }
}

