/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class EffectivePredicateExtractor {
    private static final Predicate<Map.Entry<Symbol, ? extends Expression>> SYMBOL_MATCHES_EXPRESSION = entry -> ((Expression)entry.getValue()).equals((Object)((Symbol)entry.getKey()).toSymbolReference());
    private static final Function<Map.Entry<Symbol, ? extends Expression>, Expression> ENTRY_TO_EQUALITY = entry -> {
        SymbolReference reference = ((Symbol)entry.getKey()).toSymbolReference();
        Expression expression = (Expression)entry.getValue();
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, expression);
    };
    private final ExpressionDomainTranslator domainTranslator;

    public EffectivePredicateExtractor(ExpressionDomainTranslator domainTranslator) {
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
    }

    public Expression extract(PlanNode node) {
        return node.accept(new Visitor(this.domainTranslator), null);
    }

    private static class Visitor
    extends InternalPlanVisitor<Expression, Void> {
        private final ExpressionDomainTranslator domainTranslator;

        public Visitor(ExpressionDomainTranslator domainTranslator) {
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        }

        @Override
        protected Expression visitPlan(PlanNode node, Void context) {
            return BooleanLiteral.TRUE_LITERAL;
        }

        @Override
        public Expression visitAggregation(AggregationNode node, Void context) {
            if (node.getGroupingKeys().isEmpty()) {
                return BooleanLiteral.TRUE_LITERAL;
            }
            Expression underlyingPredicate = node.getSource().accept(this, context);
            return Visitor.pullExpressionThroughSymbols(underlyingPredicate, node.getGroupingKeys());
        }

        @Override
        public Expression visitFilter(FilterNode node, Void context) {
            Expression underlyingPredicate = node.getSource().accept(this, context);
            Expression predicate = OriginalExpressionUtils.castToExpression(node.getPredicate());
            predicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
            return ExpressionUtils.combineConjuncts(predicate, underlyingPredicate);
        }

        @Override
        public Expression visitExchange(ExchangeNode node, Void context) {
            return this.deriveCommonPredicates(node, source -> {
                HashMap<Symbol, SymbolReference> mappings = new HashMap<Symbol, SymbolReference>();
                for (int i = 0; i < node.getInputs().get((int)source).size(); ++i) {
                    mappings.put(node.getOutputSymbols().get(i), node.getInputs().get((int)source).get(i).toSymbolReference());
                }
                return mappings.entrySet();
            });
        }

        @Override
        public Expression visitProject(ProjectNode node, Void context) {
            Expression underlyingPredicate = node.getSource().accept(this, context);
            List projectionEqualities = (List)node.getAssignments().entrySet().stream().filter(SYMBOL_MATCHES_EXPRESSION.negate()).map(ENTRY_TO_EQUALITY).collect(ImmutableList.toImmutableList());
            return Visitor.pullExpressionThroughSymbols(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll((Iterable)projectionEqualities).add((Object)underlyingPredicate).build()), node.getOutputSymbols());
        }

        @Override
        public Expression visitTopN(TopNNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitLimit(LimitNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitAssignUniqueId(AssignUniqueId node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitDistinctLimit(DistinctLimitNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitTableScan(TableScanNode node, Void context) {
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            return this.domainTranslator.toPredicate((TupleDomain<Symbol>)node.getCurrentConstraint().simplify().transform(((Map)assignments)::get));
        }

        @Override
        public Expression visitSort(SortNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitWindow(WindowNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitUnion(UnionNode node, Void context) {
            return this.deriveCommonPredicates(node, source -> Multimaps.transformValues(node.outputSymbolMap((int)source), Symbol::toSymbolReference).entries());
        }

        @Override
        public Expression visitJoin(JoinNode node, Void context) {
            Expression leftPredicate = node.getLeft().accept(this, context);
            Expression rightPredicate = node.getRight().accept(this, context);
            List joinConjuncts = (List)node.getCriteria().stream().map(JoinNodeUtils::toExpression).collect(ImmutableList.toImmutableList());
            switch (node.getType()) {
                case INNER: {
                    return Visitor.pullExpressionThroughSymbols(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)leftPredicate).add((Object)rightPredicate).add((Object)ExpressionUtils.combineConjuncts(joinConjuncts)).add((Object)node.getFilter().map(OriginalExpressionUtils::castToExpression).orElse((Expression)BooleanLiteral.TRUE_LITERAL)).build()), node.getOutputSymbols());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputSymbols()::contains;
                    Predicate[] predicateArray2 = new Predicate[1];
                    predicateArray2[0] = node.getRight().getOutputSymbols()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)Visitor.pullExpressionThroughSymbols(leftPredicate, node.getOutputSymbols())).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputSymbols(), predicateArray)).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputSymbols(), predicateArray2)).build());
                }
                case RIGHT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputSymbols()::contains;
                    Predicate[] predicateArray3 = new Predicate[1];
                    predicateArray3[0] = node.getLeft().getOutputSymbols()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)Visitor.pullExpressionThroughSymbols(rightPredicate, node.getOutputSymbols())).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(leftPredicate), node.getOutputSymbols(), predicateArray)).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputSymbols(), predicateArray3)).build());
                }
                case FULL: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getLeft().getOutputSymbols()::contains;
                    Predicate[] predicateArray4 = new Predicate[1];
                    predicateArray4[0] = node.getRight().getOutputSymbols()::contains;
                    Predicate[] predicateArray5 = new Predicate[2];
                    predicateArray5[0] = node.getLeft().getOutputSymbols()::contains;
                    predicateArray5[1] = node.getRight().getOutputSymbols()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll(Visitor.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(leftPredicate), node.getOutputSymbols(), predicateArray)).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputSymbols(), predicateArray4)).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(joinConjuncts, node.getOutputSymbols(), predicateArray5)).build());
                }
            }
            throw new UnsupportedOperationException("Unknown join type: " + (Object)((Object)node.getType()));
        }

        private static Iterable<Expression> pullNullableConjunctsThroughOuterJoin(List<Expression> conjuncts, Collection<Symbol> outputSymbols, Predicate<Symbol> ... nullSymbolScopes) {
            return (Iterable)conjuncts.stream().map(expression -> Visitor.pullExpressionThroughSymbols(expression, outputSymbols)).map(expression -> SymbolsExtractor.extractAll(expression).isEmpty() ? BooleanLiteral.TRUE_LITERAL : expression).map(ExpressionUtils.expressionOrNullSymbols(nullSymbolScopes)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public Expression visitSemiJoin(SemiJoinNode node, Void context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public Expression visitSpatialJoin(SpatialJoinNode node, Void context) {
            Expression leftPredicate = node.getLeft().accept(this, context);
            Expression rightPredicate = node.getRight().accept(this, context);
            switch (node.getType()) {
                case INNER: {
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)Visitor.pullExpressionThroughSymbols(leftPredicate, node.getOutputSymbols())).add((Object)Visitor.pullExpressionThroughSymbols(rightPredicate, node.getOutputSymbols())).build());
                }
                case LEFT: {
                    Predicate[] predicateArray = new Predicate[1];
                    predicateArray[0] = node.getRight().getOutputSymbols()::contains;
                    return ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().add((Object)Visitor.pullExpressionThroughSymbols(leftPredicate, node.getOutputSymbols())).addAll(Visitor.pullNullableConjunctsThroughOuterJoin(ExpressionUtils.extractConjuncts(rightPredicate), node.getOutputSymbols(), predicateArray)).build());
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
        }

        private Expression deriveCommonPredicates(PlanNode node, Function<Integer, Collection<Map.Entry<Symbol, SymbolReference>>> mapping) {
            ArrayList<ImmutableSet> sourceOutputConjuncts = new ArrayList<ImmutableSet>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression underlyingPredicate = node.getSources().get(i).accept(this, null);
                List equalities = (List)mapping.apply(i).stream().filter(SYMBOL_MATCHES_EXPRESSION.negate()).map(ENTRY_TO_EQUALITY).collect(ImmutableList.toImmutableList());
                sourceOutputConjuncts.add(ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(Visitor.pullExpressionThroughSymbols(ExpressionUtils.combineConjuncts((Collection<Expression>)ImmutableList.builder().addAll((Iterable)equalities).add((Object)underlyingPredicate).build()), node.getOutputSymbols()))));
            }
            Iterator iterator = sourceOutputConjuncts.iterator();
            Set potentialOutputConjuncts = (Set)iterator.next();
            while (iterator.hasNext()) {
                potentialOutputConjuncts = Sets.intersection((Set)potentialOutputConjuncts, (Set)((Set)iterator.next()));
            }
            return ExpressionUtils.combineConjuncts(potentialOutputConjuncts);
        }

        private static List<Expression> pullExpressionsThroughSymbols(List<Expression> expressions, Collection<Symbol> symbols) {
            return (List)expressions.stream().map(expression -> Visitor.pullExpressionThroughSymbols(expression, symbols)).collect(ImmutableList.toImmutableList());
        }

        private static Expression pullExpressionThroughSymbols(Expression expression, Collection<Symbol> symbols) {
            EqualityInference equalityInference = EqualityInference.createEqualityInference(expression);
            ImmutableList.Builder effectiveConjuncts = ImmutableList.builder();
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(expression)) {
                Expression rewritten;
                if (!ExpressionDeterminismEvaluator.isDeterministic(conjunct) || (rewritten = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(symbols))) == null) continue;
                effectiveConjuncts.add((Object)rewritten);
            }
            effectiveConjuncts.addAll(equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(symbols)).getScopeEqualities());
            return ExpressionUtils.combineConjuncts((Collection<Expression>)effectiveConjuncts.build());
        }
    }
}

