/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.project.PageFieldsToInputParametersRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.Predicate;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.LambdaExpressionExtractor;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.inject.Inject;

public class RowExpressionPredicateCompiler
implements PredicateCompiler {
    private final FunctionManager functionManager;
    private final LoadingCache<RowExpression, Supplier<Predicate>> predicateCache;

    @Inject
    public RowExpressionPredicateCompiler(Metadata metadata) {
        this(Objects.requireNonNull(metadata, "metadata is null").getFunctionManager(), 10000);
    }

    public RowExpressionPredicateCompiler(FunctionManager functionManager, int predicateCacheSize) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.predicateCache = predicateCacheSize > 0 ? CacheBuilder.newBuilder().recordStats().maximumSize((long)predicateCacheSize).build(CacheLoader.from(this::compilePredicateInternal)) : null;
    }

    public Supplier<Predicate> compilePredicate(RowExpression predicate) {
        if (this.predicateCache == null) {
            return this.compilePredicateInternal(predicate);
        }
        return (Supplier)this.predicateCache.getUnchecked((Object)predicate);
    }

    private Supplier<Predicate> compilePredicateInternal(RowExpression predicate) {
        Class<Predicate> predicateClass;
        Objects.requireNonNull(predicate, "predicate is null");
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(predicate);
        int[] inputChannels = result.getInputChannels().getInputChannels().stream().mapToInt(Integer::intValue).toArray();
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.definePredicateClass(result.getRewrittenExpression(), inputChannels, callSiteBinder);
        try {
            predicateClass = CompilerUtils.defineClass(classDefinition, Predicate.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, predicate.toString(), e.getCause());
        }
        return () -> {
            try {
                return (Predicate)predicateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private ClassDefinition definePredicateClass(RowExpression predicate, int[] inputChannels, CallSiteBinder callSiteBinder) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Predicate.class.getSimpleName(), Optional.empty()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Predicate.class)});
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        this.generatePredicateMethod(classDefinition, callSiteBinder, cachedInstanceBinder, predicate);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(int[].class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputChannels, int[].class), "getInputChannels")).retObject();
        RowExpressionPredicateCompiler.generateConstructor(classDefinition, cachedInstanceBinder);
        return classDefinition;
    }

    private MethodDefinition generatePredicateMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression predicate) {
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, predicate);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluate", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)position).build());
        method.comment("Predicate: %s", new Object[]{predicate.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        RowExpressionPredicateCompiler.declareBlockVariables(predicate, page, scope, body);
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, RowExpressionPredicateCompiler.fieldReferenceCompiler(callSiteBinder), this.functionManager, compiledLambdaMap);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(compiler.compile(predicate, scope, Optional.empty())).putVariable(result).append((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)wasNullVariable), (BytecodeExpression)result).ret());
        return method;
    }

    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(expression));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build(), callSiteBinder, cachedInstanceBinder, this.functionManager);
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.build();
    }

    private static void declareBlockVariables(RowExpression expression, Parameter page, Scope scope, BytecodeBlock body) {
        for (int channel : RowExpressionPredicateCompiler.getInputChannels(expression)) {
            scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
        }
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return RowExpressionPredicateCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(CallSiteBinder callSiteBinder) {
        return new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> scope.getVariable("position"), callSiteBinder);
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }
}

