/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class LambdaExpressionExtractor {
    private LambdaExpressionExtractor() {
    }

    public static List<LambdaDefinitionExpression> extractLambdaExpressions(RowExpression expression) {
        Visitor visitor = new Visitor();
        expression.accept((RowExpressionVisitor)visitor, (Object)new Context(false));
        return visitor.getLambdaExpressionsPostOrder();
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<Void, Context> {
        private final ImmutableList.Builder<LambdaDefinitionExpression> lambdaExpressions = ImmutableList.builder();

        private Visitor() {
        }

        public Void visitInputReference(InputReferenceExpression node, Context context) {
            return null;
        }

        public Void visitCall(CallExpression call, Context context) {
            for (RowExpression rowExpression : call.getArguments()) {
                rowExpression.accept((RowExpressionVisitor)this, (Object)context);
            }
            return null;
        }

        public Void visitConstant(ConstantExpression literal, Context context) {
            return null;
        }

        public Void visitLambda(LambdaDefinitionExpression lambda, Context context) {
            lambda.getBody().accept((RowExpressionVisitor)this, (Object)new Context(true));
            this.lambdaExpressions.add((Object)lambda);
            return null;
        }

        public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
            return null;
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, Context context) {
            for (RowExpression rowExpression : specialForm.getArguments()) {
                rowExpression.accept((RowExpressionVisitor)this, (Object)context);
            }
            return null;
        }

        private List<LambdaDefinitionExpression> getLambdaExpressionsPostOrder() {
            return this.lambdaExpressions.build();
        }
    }
}

