/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.util.List;
import java.util.Optional;

public class IfCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        Variable wasNull = context.wasNull();
        BytecodeBlock condition = new BytecodeBlock().append(context.generate(arguments.get(0), Optional.empty())).comment("... and condition value was not null").append((BytecodeNode)wasNull).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, new Class[]{Boolean.TYPE}).invokeStatic(CompilerOperations.class, "and", Boolean.TYPE, new Class[]{Boolean.TYPE, Boolean.TYPE}).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)new IfStatement().condition((BytecodeNode)condition).ifTrue(context.generate(arguments.get(1), Optional.empty())).ifFalse(context.generate(arguments.get(2), Optional.empty())));
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(context, returnType, output)));
        return block;
    }
}

