/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.presto.server.smile.BaseResponse;
import com.google.common.base.Verify;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HeaderName;
import java.util.List;
import java.util.Objects;

public class JsonResponseWrapper<T>
implements BaseResponse<T> {
    private final FullJsonResponseHandler.JsonResponse<T> jsonResponse;

    private JsonResponseWrapper(FullJsonResponseHandler.JsonResponse<T> jsonResponse) {
        this.jsonResponse = Objects.requireNonNull(jsonResponse, "jsonResponse is null");
    }

    public static <T> JsonResponseWrapper<T> wrapJsonResponse(FullJsonResponseHandler.JsonResponse<T> response) {
        return new JsonResponseWrapper<T>(response);
    }

    public static <T> FullJsonResponseHandler.JsonResponse<T> unwrapJsonResponse(BaseResponse<T> response) {
        Verify.verify((boolean)(response instanceof JsonResponseWrapper));
        return ((JsonResponseWrapper)response).jsonResponse;
    }

    @Override
    public int getStatusCode() {
        return this.jsonResponse.getStatusCode();
    }

    @Override
    public String getStatusMessage() {
        return this.jsonResponse.getStatusMessage();
    }

    @Override
    public String getHeader(String name) {
        return this.jsonResponse.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.jsonResponse.getHeaders(name);
    }

    @Override
    public ListMultimap<HeaderName, String> getHeaders() {
        return this.jsonResponse.getHeaders();
    }

    @Override
    public boolean hasValue() {
        return this.jsonResponse.hasValue();
    }

    @Override
    public T getValue() {
        return (T)this.jsonResponse.getValue();
    }

    @Override
    public int getResponseSize() {
        return this.jsonResponse.getResponseSize();
    }

    @Override
    public byte[] getResponseBytes() {
        return this.jsonResponse.getResponseBytes();
    }

    @Override
    public Exception getException() {
        return this.jsonResponse.getException();
    }
}

