/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import io.airlift.stats.DistributionStat;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RemoteTaskStats {
    private final IncrementalAverage updateRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage infoRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage statusRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage responseSizeBytes = new IncrementalAverage();
    private final DistributionStat updateWithPlanBytes = new DistributionStat();
    private long requestSuccess;
    private long requestFailure;

    public void statusRoundTripMillis(long roundTripMillis) {
        this.statusRoundTripMillis.add(roundTripMillis);
    }

    public void infoRoundTripMillis(long roundTripMillis) {
        this.infoRoundTripMillis.add(roundTripMillis);
    }

    public void updateRoundTripMillis(long roundTripMillis) {
        this.updateRoundTripMillis.add(roundTripMillis);
    }

    public void responseSize(long responseSizeBytes) {
        this.responseSizeBytes.add(responseSizeBytes);
    }

    public void updateSuccess() {
        ++this.requestSuccess;
    }

    public void updateFailure() {
        ++this.requestFailure;
    }

    public void updateWithPlanBytes(long bytes) {
        this.updateWithPlanBytes.add(bytes);
    }

    @Managed
    public double getResponseSizeBytes() {
        return this.responseSizeBytes.get();
    }

    @Managed
    public double getStatusRoundTripMillis() {
        return this.statusRoundTripMillis.get();
    }

    @Managed
    public double getUpdateRoundTripMillis() {
        return this.updateRoundTripMillis.get();
    }

    @Managed
    public double getInfoRoundTripMillis() {
        return this.infoRoundTripMillis.get();
    }

    @Managed
    public long getRequestSuccess() {
        return this.requestSuccess;
    }

    @Managed
    public long getRequestFailure() {
        return this.requestFailure;
    }

    @Managed
    @Nested
    public DistributionStat getUpdateWithPlanBytes() {
        return this.updateWithPlanBytes;
    }

    @ThreadSafe
    private static class IncrementalAverage {
        private long count;
        private volatile double average;

        private IncrementalAverage() {
        }

        synchronized void add(long value) {
            ++this.count;
            this.average += ((double)value - this.average) / (double)this.count;
        }

        double get() {
            return this.average;
        }
    }
}

