/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.HyperLogLogUtils;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;

public final class HyperLogLogFunctions {
    private HyperLogLogFunctions() {
    }

    @ScalarFunction
    @Description(value="compute the cardinality of a HyperLogLog instance")
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="HyperLogLog") Slice serializedHll) {
        return HyperLogLog.newInstance((Slice)serializedHll).cardinality();
    }

    @ScalarFunction
    @Description(value="an empty HyperLogLog instance")
    @SqlType(value="HyperLogLog")
    public static Slice emptyApproxSet() {
        return HyperLogLog.newInstance((int)HyperLogLogUtils.standardErrorToBuckets(0.01625)).serialize();
    }

    @ScalarFunction
    @Description(value="an empty HyperLogLog instance with the specified max standard error")
    @SqlType(value="HyperLogLog")
    public static Slice emptyApproxSet(@SqlType(value="double") double maxStandardError) {
        return HyperLogLog.newInstance((int)HyperLogLogUtils.standardErrorToBuckets(maxStandardError)).serialize();
    }
}

