/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.FixedDoubleHistogram;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class PrecisionRecallAggregation {
    private static final double DEFAULT_WEIGHT = 1.0;
    private static final double MIN_PREDICTION_VALUE = 0.0;
    private static final double MAX_PREDICTION_VALUE = 1.0;
    private static final String ILLEGAL_PREDICTION_VALUE_MESSAGE = String.format("Prediction value must be between %s and %s", 0.0, 1.0);
    private static final String NEGATIVE_WEIGHT_MESSAGE = "Weights must be non-negative";
    private static final String INCONSISTENT_BUCKET_COUNT_MESSAGE = "Bucket count must be constant";

    protected PrecisionRecallAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState PrecisionRecallState state, @SqlType(value="bigint") long bucketCount, @SqlType(value="boolean") boolean outcome, @SqlType(value="double") double pred, @SqlType(value="double") double weight) {
        if (state.getTrueWeights() == null) {
            state.setTrueWeights(new FixedDoubleHistogram((int)bucketCount, 0.0, 1.0));
            state.setFalseWeights(new FixedDoubleHistogram((int)bucketCount, 0.0, 1.0));
        }
        if (pred < 0.0 || pred > 1.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, ILLEGAL_PREDICTION_VALUE_MESSAGE);
        }
        if (weight < 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, NEGATIVE_WEIGHT_MESSAGE);
        }
        if (bucketCount != (long)state.getTrueWeights().getBucketCount()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, INCONSISTENT_BUCKET_COUNT_MESSAGE);
        }
        if (outcome) {
            state.getTrueWeights().add(pred, weight);
        } else {
            state.getFalseWeights().add(pred, weight);
        }
    }

    @InputFunction
    public static void input(@AggregationState PrecisionRecallState state, @SqlType(value="bigint") long bucketCount, @SqlType(value="boolean") boolean outcome, @SqlType(value="double") double pred) {
        PrecisionRecallAggregation.input(state, bucketCount, outcome, pred, 1.0);
    }

    @CombineFunction
    public static void combine(@AggregationState PrecisionRecallState state, @AggregationState PrecisionRecallState otherState) {
        if (state.getTrueWeights() == null && otherState.getTrueWeights() != null) {
            state.setTrueWeights(new FixedDoubleHistogram(otherState.getTrueWeights().clone()));
            state.setFalseWeights(new FixedDoubleHistogram(otherState.getFalseWeights().clone()));
            return;
        }
        if (state.getTrueWeights() != null && otherState.getTrueWeights() != null) {
            state.getTrueWeights().mergeWith(otherState.getTrueWeights());
            state.getFalseWeights().mergeWith(otherState.getFalseWeights());
        }
    }

    protected static Iterator<BucketResult> getResultsIterator(final @AggregationState PrecisionRecallState state) {
        if (state.getTrueWeights() == null) {
            return Collections.emptyList().iterator();
        }
        final double totalTrueWeight = Streams.stream(state.getTrueWeights().iterator()).mapToDouble(c -> c.weight).sum();
        final double totalFalseWeight = Streams.stream(state.getFalseWeights().iterator()).mapToDouble(c -> c.weight).sum();
        return new Iterator<BucketResult>(){
            Iterator<FixedDoubleHistogram.Bin> trueIt;
            Iterator<FixedDoubleHistogram.Bin> falseIt;
            double runningFalseWeight;
            double runningTrueWeight;
            {
                this.trueIt = state.getTrueWeights().iterator();
                this.falseIt = state.getFalseWeights().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.trueIt.hasNext() && totalTrueWeight > this.runningTrueWeight;
            }

            @Override
            public BucketResult next() {
                if (!this.trueIt.hasNext() || !this.falseIt.hasNext()) {
                    throw new NoSuchElementException();
                }
                FixedDoubleHistogram.Bin trueResult = this.trueIt.next();
                FixedDoubleHistogram.Bin falseResult = this.falseIt.next();
                BucketResult result = new BucketResult(trueResult.left, trueResult.right, totalTrueWeight, totalFalseWeight, this.runningTrueWeight, this.runningFalseWeight);
                this.runningTrueWeight += trueResult.weight;
                this.runningFalseWeight += falseResult.weight;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static class BucketResult {
        public final double totalTrueWeight;
        public final double totalFalseWeight;
        public final double runningTrueWeight;
        public final double runningFalseWeight;
        public final double left;
        public final double right;

        public BucketResult(double left, double right, double totalTrueWeight, double totalFalseWeight, double runningTrueWeight, double runningFalseWeight) {
            this.left = left;
            this.right = right;
            this.totalTrueWeight = totalTrueWeight;
            this.totalFalseWeight = totalFalseWeight;
            this.runningTrueWeight = runningTrueWeight;
            this.runningFalseWeight = runningFalseWeight;
        }
    }
}

