/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjdk.jol.info.ClassLayout;

public class FixedDoubleHistogram
implements Cloneable,
Iterable<Bin> {
    private static final byte FORMAT_TAG = 0;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedDoubleHistogram.class).instanceSize();
    private final int bucketCount;
    private final double min;
    private final double max;
    private final double[] weights;

    public FixedDoubleHistogram(int bucketCount, double min, double max) {
        Preconditions.checkArgument((bucketCount >= 2 ? 1 : 0) != 0, (String)"bucketCount %s must be >= 2", (int)bucketCount);
        Preconditions.checkArgument((min < max ? 1 : 0) != 0, (String)"min %s must be greater than max %s ", (Object)min, (Object)max);
        this.bucketCount = bucketCount;
        this.min = min;
        this.max = max;
        this.weights = new double[bucketCount];
    }

    public FixedDoubleHistogram(SliceInput input) {
        Preconditions.checkArgument((input.readByte() == 0 ? 1 : 0) != 0, (Object)"Unsupported format tag");
        this.bucketCount = input.readInt();
        Preconditions.checkArgument((this.bucketCount >= 2 ? 1 : 0) != 0, (String)"bucketCount %s must be >= 2", (int)this.bucketCount);
        this.min = input.readDouble();
        this.max = input.readDouble();
        Preconditions.checkArgument((this.min < this.max ? 1 : 0) != 0, (String)"min %s must be greater than max %s ", (Object)this.min, (Object)this.max);
        this.weights = new double[this.bucketCount];
        input.readBytes(Slices.wrappedDoubleArray((double[])this.weights), this.bucketCount * 8);
    }

    protected FixedDoubleHistogram(FixedDoubleHistogram other) {
        this(other.bucketCount, other.min, other.max);
        for (int i = 0; i < this.bucketCount; ++i) {
            this.weights[i] = other.weights[i];
        }
    }

    public FixedDoubleHistogram clone() {
        return new FixedDoubleHistogram(this);
    }

    int getBucketCount() {
        return this.bucketCount;
    }

    double getMin() {
        return this.min;
    }

    double getMax() {
        return this.max;
    }

    public int getRequiredBytesForSerialization() {
        return 21 + 8 * this.bucketCount;
    }

    public void serialize(SliceOutput out) {
        out.appendByte(0).appendInt(this.bucketCount).appendDouble(this.min).appendDouble(this.max).appendBytes(Slices.wrappedDoubleArray((double[])this.weights, (int)0, (int)this.bucketCount));
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((double[])this.weights);
    }

    public void set(double value, double weight) {
        Preconditions.checkArgument((value >= this.min && value <= this.max ? 1 : 0) != 0, (String)"value must be within range [%s, %s]", (Object)this.min, (Object)this.max);
        this.weights[this.getIndexForValue((double)value)] = weight;
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        int n = this.getIndexForValue(value);
        this.weights[n] = this.weights[n] + weight;
    }

    public void mergeWith(FixedDoubleHistogram other) {
        Preconditions.checkArgument((this.min == other.min ? 1 : 0) != 0, (String)"min %s must be equal to other min %s", (Object)this.min, (Object)other.min);
        Preconditions.checkArgument((this.max == other.max ? 1 : 0) != 0, (String)"max %s must be equal to other max %s", (Object)this.max, (Object)other.max);
        Preconditions.checkArgument((this.bucketCount == other.bucketCount ? 1 : 0) != 0, (String)"bucketCount %s must be equal to other bucketCount %s", (int)this.bucketCount, (int)other.bucketCount);
        for (int i = 0; i < this.bucketCount; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + other.weights[i];
        }
    }

    @Override
    public Iterator<Bin> iterator() {
        return new Iterator<Bin>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < FixedDoubleHistogram.this.bucketCount;
            }

            @Override
            public Bin next() {
                if (this.currentIndex == FixedDoubleHistogram.this.bucketCount) {
                    throw new NoSuchElementException();
                }
                return new Bin((double)this.currentIndex * (FixedDoubleHistogram.this.max - FixedDoubleHistogram.this.min) / (double)FixedDoubleHistogram.this.bucketCount, (double)(this.currentIndex + 1) * (FixedDoubleHistogram.this.max - FixedDoubleHistogram.this.min) / (double)FixedDoubleHistogram.this.bucketCount, FixedDoubleHistogram.this.weights[this.currentIndex++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int getIndexForValue(double value) {
        Preconditions.checkArgument((value >= this.min && value <= this.max ? 1 : 0) != 0, (String)"value must be within range [%s, %s]", (Object)this.min, (Object)this.max);
        return Math.min((int)((double)this.bucketCount * (value - this.min) / (this.max - this.min)), this.bucketCount - 1);
    }

    public class Bin {
        public final double left;
        public final double right;
        public final double weight;

        public Bin(double left, double right, double weight) {
            this.left = left;
            this.right = right;
            this.weight = weight;
        }
    }
}

