/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.PrecisionRecallAggregation;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.type.DoubleType;
import java.util.Iterator;

@AggregationFunction(value="classification_recall")
@Description(value="Computes recall for precision-recall curves")
public final class ClassificationRecallAggregation
extends PrecisionRecallAggregation {
    private ClassificationRecallAggregation() {
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState PrecisionRecallState state, BlockBuilder out) {
        Iterator<PrecisionRecallAggregation.BucketResult> resultsIterator = ClassificationRecallAggregation.getResultsIterator(state);
        BlockBuilder entryBuilder = out.beginBlockEntry();
        while (resultsIterator.hasNext()) {
            PrecisionRecallAggregation.BucketResult result = resultsIterator.next();
            double remainingTrueWeight = result.totalTrueWeight - result.runningTrueWeight;
            DoubleType.DOUBLE.writeDouble(entryBuilder, remainingTrueWeight / result.totalTrueWeight);
        }
        out.closeEntry();
    }
}

