/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.PrecisionRecallAggregation;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.type.DoubleType;
import java.util.Iterator;

@AggregationFunction(value="classification_miss_rate")
@Description(value="Computes miss-rate for precision-recall curves")
public final class ClassificationMissRateAggregation
extends PrecisionRecallAggregation {
    private ClassificationMissRateAggregation() {
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState PrecisionRecallState state, BlockBuilder out) {
        Iterator<PrecisionRecallAggregation.BucketResult> resultsIterator = ClassificationMissRateAggregation.getResultsIterator(state);
        BlockBuilder entryBuilder = out.beginBlockEntry();
        while (resultsIterator.hasNext()) {
            PrecisionRecallAggregation.BucketResult result = resultsIterator.next();
            DoubleType.DOUBLE.writeDouble(entryBuilder, result.runningFalseWeight / result.totalTrueWeight);
        }
        out.closeEntry();
    }
}

