/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.RemoteSplit;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class ExchangeOperator
implements SourceOperator,
Closeable {
    public static final ConnectorId REMOTE_CONNECTOR_ID = new ConnectorId("$remote");
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final ExchangeClient exchangeClient;
    private final PagesSerde serde;

    public ExchangeOperator(OperatorContext operatorContext, PlanNodeId sourceId, PagesSerde serde, ExchangeClient exchangeClient) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.exchangeClient = Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        operatorContext.setInfoSupplier(exchangeClient::getStatus);
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)split.getConnectorId().equals(REMOTE_CONNECTOR_ID), (Object)"split is not a remote split");
        RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
        this.exchangeClient.addLocation(remoteSplit.getLocation(), remoteSplit.getRemoteSourceTaskId());
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.exchangeClient.noMoreLocations();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.exchangeClient.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.exchangeClient.isBlocked();
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        SerializedPage page = this.exchangeClient.pollPage();
        if (page == null) {
            return null;
        }
        this.operatorContext.recordRawInput(page.getSizeInBytes());
        Page deserializedPage = this.serde.deserialize(page);
        this.operatorContext.recordProcessedInput(deserializedPage.getSizeInBytes(), page.getPositionCount());
        return deserializedPage;
    }

    @Override
    public void close() {
        this.exchangeClient.close();
    }

    public static class ExchangeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final TaskExchangeClientManager taskExchangeClientManager;
        private final PagesSerdeFactory serdeFactory;
        private ExchangeClient exchangeClient;
        private boolean closed;

        public ExchangeOperatorFactory(int operatorId, PlanNodeId sourceId, TaskExchangeClientManager taskExchangeClientManager, PagesSerdeFactory serdeFactory) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.taskExchangeClientManager = Objects.requireNonNull(taskExchangeClientManager, "taskExchangeClientManager is null");
            this.serdeFactory = serdeFactory;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, ExchangeOperator.class.getSimpleName());
            if (this.exchangeClient == null) {
                this.exchangeClient = this.taskExchangeClientManager.createExchangeClient(driverContext.getPipelineContext().localSystemMemoryContext());
            }
            return new ExchangeOperator(operatorContext, this.sourceId, this.serdeFactory.createPagesSerde(), this.exchangeClient);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

