/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class ArrayUnnester
implements Unnester {
    private final Type elementType;
    private Block arrayBlock;
    private int position;
    private int positionCount;

    public ArrayUnnester(Type elementType) {
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
    }

    @Override
    public boolean hasNext() {
        return this.position < this.positionCount;
    }

    @Override
    public final int getChannelCount() {
        return 1;
    }

    @Override
    public final void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkState((this.arrayBlock != null ? 1 : 0) != 0, (Object)"arrayBlock is null");
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        this.elementType.appendTo(this.arrayBlock, this.position, blockBuilder);
        ++this.position;
    }

    @Override
    public void setBlock(@Nullable Block arrayBlock) {
        this.arrayBlock = arrayBlock;
        this.position = 0;
        this.positionCount = arrayBlock == null ? 0 : arrayBlock.getPositionCount();
    }
}

