/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.NodeState;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class InMemoryNodeManager
implements InternalNodeManager {
    private final InternalNode localNode;
    private final SetMultimap<ConnectorId, InternalNode> remoteNodes = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @GuardedBy(value="this")
    private final List<Consumer<AllNodes>> listeners = new ArrayList<Consumer<AllNodes>>();

    @Inject
    public InMemoryNodeManager() {
        this(URI.create("local://127.0.0.1"));
    }

    public InMemoryNodeManager(URI localUri) {
        this.localNode = new InternalNode("local", localUri, NodeVersion.UNKNOWN, false);
    }

    public void addCurrentNodeConnector(ConnectorId connectorId) {
        this.addNode(connectorId, this.localNode);
    }

    public void addNode(ConnectorId connectorId, InternalNode ... nodes) {
        this.addNode(connectorId, (Iterable<InternalNode>)ImmutableList.copyOf((Object[])nodes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(ConnectorId connectorId, Iterable<InternalNode> nodes) {
        ImmutableList listeners;
        this.remoteNodes.putAll((Object)connectorId, nodes);
        InMemoryNodeManager inMemoryNodeManager = this;
        synchronized (inMemoryNodeManager) {
            listeners = ImmutableList.copyOf(this.listeners);
        }
        AllNodes allNodes = this.getAllNodes();
        listeners.forEach(listener -> listener.accept(allNodes));
    }

    @Override
    public Set<InternalNode> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return this.getAllNodes().getActiveNodes();
            }
            case INACTIVE: {
                return this.getAllNodes().getInactiveNodes();
            }
            case SHUTTING_DOWN: {
                return this.getAllNodes().getShuttingDownNodes();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + state);
    }

    @Override
    public Set<InternalNode> getActiveConnectorNodes(ConnectorId connectorId) {
        return ImmutableSet.copyOf((Collection)this.remoteNodes.get((Object)connectorId));
    }

    @Override
    public AllNodes getAllNodes() {
        return new AllNodes((Set<InternalNode>)ImmutableSet.builder().add((Object)this.localNode).addAll((Iterable)this.remoteNodes.values()).build(), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of((Object)this.localNode));
    }

    @Override
    public InternalNode getCurrentNode() {
        return this.localNode;
    }

    @Override
    public Set<InternalNode> getCoordinators() {
        return ImmutableSet.of((Object)this.localNode);
    }

    @Override
    public void refreshNodes() {
    }

    @Override
    public synchronized void addNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener is null"));
    }

    @Override
    public synchronized void removeNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.remove(Objects.requireNonNull(listener, "listener is null"));
    }
}

