/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.concurrent.GuardedBy;

public class FixedLifespanScheduler
implements LifespanScheduler {
    private final Int2ObjectMap<InternalNode> driverGroupToNodeMap;
    private final Map<InternalNode, IntListIterator> nodeToDriverGroupsMap;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final OptionalInt concurrentLifespansPerTask;
    private boolean initialScheduled;
    private SettableFuture<?> newDriverGroupReady = SettableFuture.create();
    @GuardedBy(value="this")
    private final List<Lifespan> recentlyCompletelyExecutedDriverGroups = new ArrayList<Lifespan>();
    @GuardedBy(value="this")
    private int totalLifespanExecutionFinished;

    public FixedLifespanScheduler(BucketNodeMap bucketNodeMap, List<ConnectorPartitionHandle> partitionHandles, OptionalInt concurrentLifespansPerTask) {
        Preconditions.checkArgument((!partitionHandles.equals(ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED)) ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionHandles.size() == bucketNodeMap.getBucketCount() ? 1 : 0) != 0);
        HashMap<InternalNode, IntList> nodeToDriverGroupMap = new HashMap<InternalNode, IntList>();
        Int2ObjectOpenHashMap driverGroupToNodeMap = new Int2ObjectOpenHashMap();
        for (int bucket = 0; bucket < bucketNodeMap.getBucketCount(); ++bucket) {
            InternalNode node = bucketNodeMap.getAssignedNode(bucket).get();
            nodeToDriverGroupMap.computeIfAbsent(node, key -> new IntArrayList()).add(bucket);
            driverGroupToNodeMap.put(bucket, (Object)node);
        }
        this.driverGroupToNodeMap = driverGroupToNodeMap;
        this.nodeToDriverGroupsMap = (Map)nodeToDriverGroupMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IntList)entry.getValue()).iterator()));
        this.partitionHandles = Objects.requireNonNull(partitionHandles, "partitionHandles is null");
        if (concurrentLifespansPerTask.isPresent()) {
            Preconditions.checkArgument((concurrentLifespansPerTask.getAsInt() >= 1 ? 1 : 0) != 0, (Object)"concurrentLifespansPerTask must be great or equal to 1 if present");
        }
        this.concurrentLifespansPerTask = Objects.requireNonNull(concurrentLifespansPerTask, "concurrentLifespansPerTask is null");
    }

    @Override
    public void scheduleInitial(SourceScheduler scheduler) {
        Preconditions.checkState((!this.initialScheduled ? 1 : 0) != 0);
        this.initialScheduled = true;
        block0: for (Map.Entry<InternalNode, IntListIterator> entry : this.nodeToDriverGroupsMap.entrySet()) {
            IntListIterator driverGroupsIterator = entry.getValue();
            int driverGroupsScheduled = 0;
            while (driverGroupsIterator.hasNext()) {
                int driverGroupId = driverGroupsIterator.nextInt();
                scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
                if (!this.concurrentLifespansPerTask.isPresent() || ++driverGroupsScheduled != this.concurrentLifespansPerTask.getAsInt()) continue;
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLifespanExecutionFinished(Iterable<Lifespan> newlyCompletelyExecutedDriverGroups) {
        SettableFuture<?> newDriverGroupReady;
        Preconditions.checkState((boolean)this.initialScheduled);
        FixedLifespanScheduler fixedLifespanScheduler = this;
        synchronized (fixedLifespanScheduler) {
            for (Lifespan newlyCompletelyExecutedDriverGroup : newlyCompletelyExecutedDriverGroups) {
                Preconditions.checkArgument((!newlyCompletelyExecutedDriverGroup.isTaskWide() ? 1 : 0) != 0);
                this.recentlyCompletelyExecutedDriverGroups.add(newlyCompletelyExecutedDriverGroup);
                ++this.totalLifespanExecutionFinished;
            }
            newDriverGroupReady = this.newDriverGroupReady;
        }
        newDriverGroupReady.set(null);
        Verify.verify((this.totalLifespanExecutionFinished <= this.partitionHandles.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettableFuture schedule(SourceScheduler scheduler) {
        ImmutableList recentlyCompletedDriverGroups;
        Preconditions.checkState((boolean)this.initialScheduled);
        FixedLifespanScheduler fixedLifespanScheduler = this;
        synchronized (fixedLifespanScheduler) {
            recentlyCompletedDriverGroups = ImmutableList.copyOf(this.recentlyCompletelyExecutedDriverGroups);
            this.recentlyCompletelyExecutedDriverGroups.clear();
            this.newDriverGroupReady = SettableFuture.create();
        }
        for (Lifespan driverGroup : recentlyCompletedDriverGroups) {
            IntListIterator driverGroupsIterator = this.nodeToDriverGroupsMap.get(this.driverGroupToNodeMap.get(driverGroup.getId()));
            if (!driverGroupsIterator.hasNext()) continue;
            int driverGroupId = driverGroupsIterator.nextInt();
            scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
        }
        return this.newDriverGroupReady;
    }

    @Override
    public synchronized boolean allLifespanExecutionFinished() {
        return this.totalLifespanExecutionFinished == this.partitionHandles.size();
    }
}

