/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.concurrent.GuardedBy;

public class DynamicLifespanScheduler
implements LifespanScheduler {
    private final BucketNodeMap bucketNodeMap;
    private final List<InternalNode> nodeByTaskId;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final OptionalInt concurrentLifespansPerTask;
    private final IntListIterator driverGroups;
    private boolean initialScheduled;
    private SettableFuture<?> newDriverGroupReady = SettableFuture.create();
    @GuardedBy(value="this")
    private final List<Lifespan> recentlyCompletelyExecutedDriverGroups = new ArrayList<Lifespan>();
    @GuardedBy(value="this")
    private int totalLifespanExecutionFinished;

    public DynamicLifespanScheduler(BucketNodeMap bucketNodeMap, List<InternalNode> nodeByTaskId, List<ConnectorPartitionHandle> partitionHandles, OptionalInt concurrentLifespansPerTask) {
        this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        this.nodeByTaskId = Objects.requireNonNull(nodeByTaskId, "nodeByTaskId is null");
        this.partitionHandles = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionHandles, "partitionHandles is null")));
        this.concurrentLifespansPerTask = Objects.requireNonNull(concurrentLifespansPerTask, "concurrentLifespansPerTask is null");
        concurrentLifespansPerTask.ifPresent(lifespansPerTask -> Preconditions.checkArgument((lifespansPerTask >= 1 ? 1 : 0) != 0, (Object)"concurrentLifespansPerTask must be great or equal to 1 if present"));
        int bucketCount = partitionHandles.size();
        Verify.verify((bucketCount > 0 ? 1 : 0) != 0);
        this.driverGroups = new IntArrayList(IntStream.range(0, bucketCount).toArray()).iterator();
    }

    @Override
    public void scheduleInitial(SourceScheduler scheduler) {
        Preconditions.checkState((!this.initialScheduled ? 1 : 0) != 0);
        this.initialScheduled = true;
        int driverGroupsScheduledPerTask = 0;
        while (this.driverGroups.hasNext()) {
            for (int i = 0; i < this.nodeByTaskId.size() && this.driverGroups.hasNext(); ++i) {
                int driverGroupId = this.driverGroups.nextInt();
                Preconditions.checkState((!this.bucketNodeMap.getAssignedNode(driverGroupId).isPresent() ? 1 : 0) != 0);
                this.bucketNodeMap.assignBucketToNode(driverGroupId, this.nodeByTaskId.get(i));
                scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
            }
            if (!this.concurrentLifespansPerTask.isPresent() || ++driverGroupsScheduledPerTask != this.concurrentLifespansPerTask.getAsInt()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLifespanExecutionFinished(Iterable<Lifespan> newlyCompletelyExecutedDriverGroups) {
        SettableFuture<?> newDriverGroupReady;
        Preconditions.checkState((boolean)this.initialScheduled);
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            for (Lifespan newlyCompletelyExecutedDriverGroup : newlyCompletelyExecutedDriverGroups) {
                Preconditions.checkArgument((!newlyCompletelyExecutedDriverGroup.isTaskWide() ? 1 : 0) != 0);
                this.recentlyCompletelyExecutedDriverGroups.add(newlyCompletelyExecutedDriverGroup);
                ++this.totalLifespanExecutionFinished;
            }
            newDriverGroupReady = this.newDriverGroupReady;
        }
        newDriverGroupReady.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettableFuture schedule(SourceScheduler scheduler) {
        ImmutableList recentlyCompletedDriverGroups;
        Preconditions.checkState((boolean)this.initialScheduled);
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            recentlyCompletedDriverGroups = ImmutableList.copyOf(this.recentlyCompletelyExecutedDriverGroups);
            this.recentlyCompletelyExecutedDriverGroups.clear();
            this.newDriverGroupReady = SettableFuture.create();
        }
        for (Lifespan driverGroup : recentlyCompletedDriverGroups) {
            if (!this.driverGroups.hasNext()) break;
            int driverGroupId = this.driverGroups.nextInt();
            InternalNode nodeForCompletedDriverGroup = this.bucketNodeMap.getAssignedNode(driverGroup.getId()).orElseThrow(IllegalStateException::new);
            this.bucketNodeMap.assignBucketToNode(driverGroupId, nodeForCompletedDriverGroup);
            scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
        }
        return this.newDriverGroupReady;
    }

    @Override
    public synchronized boolean allLifespanExecutionFinished() {
        return this.totalLifespanExecutionFinished == this.partitionHandles.size();
    }
}

