/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.buffer.PageCodecMarker;
import com.facebook.presto.execution.buffer.PagesSerdeUtil;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spiller.SpillCipher;
import com.google.common.base.Preconditions;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PagesSerde {
    private static final double MINIMUM_COMPRESSION_RATIO = 0.8;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Optional<Compressor> compressor;
    private final Optional<Decompressor> decompressor;
    private final Optional<SpillCipher> spillCipher;

    public PagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        Preconditions.checkArgument((compressor.isPresent() == decompressor.isPresent() ? 1 : 0) != 0, (Object)"compressor and decompressor must both be present or both be absent");
        this.compressor = Objects.requireNonNull(compressor, "compressor is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.spillCipher = Objects.requireNonNull(spillCipher, "spillCipher is null");
        Preconditions.checkState((!spillCipher.isPresent() || !spillCipher.get().isDestroyed() ? 1 : 0) != 0, (Object)"spillCipher is already destroyed");
    }

    public SerializedPage serialize(Page page) {
        DynamicSliceOutput serializationBuffer = new DynamicSliceOutput(Math.toIntExact(page.getSizeInBytes() + 4L));
        PagesSerdeUtil.writeRawPage(page, (SliceOutput)serializationBuffer, this.blockEncodingSerde);
        Slice slice = serializationBuffer.slice();
        int uncompressedSize = serializationBuffer.size();
        byte markers = PageCodecMarker.none();
        if (this.compressor.isPresent()) {
            ByteBuffer compressionBuffer = ByteBuffer.allocate(this.compressor.get().maxCompressedLength(uncompressedSize));
            this.compressor.get().compress(slice.toByteBuffer(), compressionBuffer);
            compressionBuffer.flip();
            if ((double)compressionBuffer.remaining() / (double)uncompressedSize <= 0.8) {
                slice = Slices.wrappedBuffer((ByteBuffer)compressionBuffer);
                markers = PageCodecMarker.COMPRESSED.set(markers);
            }
        }
        if (this.spillCipher.isPresent()) {
            slice = Slices.wrappedBuffer((ByteBuffer)this.spillCipher.get().encrypt(slice.toByteBuffer()));
            markers = PageCodecMarker.ENCRYPTED.set(markers);
        } else {
            slice = Slices.copyOf((Slice)slice);
        }
        return new SerializedPage(slice, markers, page.getPositionCount(), uncompressedSize);
    }

    public Page deserialize(SerializedPage serializedPage) {
        Preconditions.checkArgument((serializedPage != null ? 1 : 0) != 0, (Object)"serializedPage is null");
        Slice slice = serializedPage.getSlice();
        if (PageCodecMarker.ENCRYPTED.isSet(serializedPage.getPageCodecMarkers())) {
            Preconditions.checkState((boolean)this.spillCipher.isPresent(), (Object)"Page is encrypted, but spill cipher is missing");
            slice = Slices.wrappedBuffer((ByteBuffer)this.spillCipher.get().decrypt(slice.toByteBuffer()));
        }
        if (PageCodecMarker.COMPRESSED.isSet(serializedPage.getPageCodecMarkers())) {
            Preconditions.checkState((boolean)this.decompressor.isPresent(), (Object)"Page is compressed, but decompressor is missing");
            int uncompressedSize = serializedPage.getUncompressedSizeInBytes();
            ByteBuffer decompressionBuffer = ByteBuffer.allocate(uncompressedSize);
            this.decompressor.get().decompress(slice.toByteBuffer(), decompressionBuffer);
            decompressionBuffer.flip();
            Preconditions.checkState((decompressionBuffer.remaining() == uncompressedSize ? 1 : 0) != 0);
            slice = Slices.wrappedBuffer((ByteBuffer)decompressionBuffer);
        }
        return PagesSerdeUtil.readRawPage(serializedPage.getPositionCount(), (SliceInput)slice.getInput(), this.blockEncodingSerde);
    }
}

