/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum PageCodecMarker {
    COMPRESSED(1),
    ENCRYPTED(2);

    private final int mask;

    private PageCodecMarker(int bit) {
        Preconditions.checkArgument((bit > 0 && bit <= 8 ? 1 : 0) != 0, (String)"PageCodecMarker bit must be between 1 and 8. Found: %s", (int)bit);
        this.mask = 1 << bit - 1;
    }

    public boolean isSet(byte value) {
        return (Byte.toUnsignedInt(value) & this.mask) == this.mask;
    }

    public byte set(byte value) {
        return (byte)(Byte.toUnsignedInt(value) | this.mask);
    }

    public byte unset(byte value) {
        return (byte)(Byte.toUnsignedInt(value) & ~this.mask);
    }

    public static byte none() {
        return 0;
    }

    public static String toSummaryString(byte markers) {
        if (markers == PageCodecMarker.none()) {
            return "NONE";
        }
        return Arrays.stream(PageCodecMarker.values()).filter(marker -> marker.isSet(markers)).map(Enum::name).collect(Collectors.joining(", "));
    }
}

