/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final StageState state;
    private final URI self;
    private final Optional<PlanFragment> plan;
    private final List<Type> types;
    private final StageStats stageStats;
    private final List<TaskInfo> tasks;
    private final List<StageInfo> subStages;
    private final Optional<ExecutionFailureInfo> failureCause;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="self") URI self, @JsonProperty(value="plan") Optional<PlanFragment> plan, @JsonProperty(value="types") List<Type> types, @JsonProperty(value="stageStats") StageStats stageStats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="failureCause") Optional<ExecutionFailureInfo> failureCause) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.stageStats = Objects.requireNonNull(stageStats, "stageStats is null");
        this.tasks = ImmutableList.copyOf((Collection)Objects.requireNonNull(tasks, "tasks is null"));
        this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "subStages is null"));
        this.failureCause = Objects.requireNonNull(failureCause, "failureCause is null");
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public Optional<PlanFragment> getPlan() {
        return this.plan;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public StageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public Optional<ExecutionFailureInfo> getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinalStageInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public List<StageInfo> getAllStages() {
        return ImmutableList.copyOf((Iterable)Traverser.forTree(StageInfo::getSubStages).depthFirstPreOrder((Object)this));
    }

    public static List<StageInfo> getAllStages(Optional<StageInfo> stageInfo) {
        return stageInfo.map(StageInfo::getAllStages).orElse((List)ImmutableList.of());
    }
}

