/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientCapabilities;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlPath;
import com.facebook.presto.sql.SqlPathElement;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SetPath;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SetPathTask
implements DataDefinitionTask<SetPath> {
    @Override
    public String getName() {
        return "SET PATH";
    }

    @Override
    public ListenableFuture<?> execute(SetPath statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (!session.getClientCapabilities().contains(ClientCapabilities.PATH.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SET PATH not supported by client");
        }
        SqlPath sqlPath = new SqlPath(Optional.of(statement.getPathSpecification().toString()));
        for (SqlPathElement element : sqlPath.getParsedPath()) {
            if (!element.getCatalog().isPresent() && !session.getCatalog().isPresent()) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)statement, "Catalog must be specified for each path element when session catalog is not set", new Object[0]);
            }
            element.getCatalog().ifPresent(catalog -> {
                String catalogName = catalog.getValue().toLowerCase(Locale.ENGLISH);
                if (!metadata.getCatalogHandle(session, catalogName).isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalogName);
                }
            });
        }
        stateMachine.setSetPath(sqlPath.toString());
        return Futures.immediateFuture(null);
    }
}

