/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.BasicStageStats;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    public static final Logger QUERY_STATE_LOG = Logger.get(QueryStateMachine.class);
    private final QueryId queryId;
    private final String query;
    private final Session session;
    private final URI self;
    private final Optional<QueryType> queryType;
    private final Optional<ResourceGroupId> resourceGroup;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final QueryOutputManager outputManager;
    private final AtomicReference<VersionedMemoryPoolId> memoryPool = new AtomicReference<VersionedMemoryPoolId>(new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L));
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();
    private final AtomicLong peakTotalMemory = new AtomicLong();
    private final AtomicLong peakTaskUserMemory = new AtomicLong();
    private final AtomicLong peakTaskTotalMemory = new AtomicLong();
    private final QueryStateTimer queryStateTimer;
    private final StateMachine<QueryState> queryState;
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final AtomicReference<String> setPath = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, SelectedRole> setRoles = new ConcurrentHashMap<String, SelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Optional<Output>> output = new AtomicReference(Optional.empty());
    private final StateMachine<Optional<QueryInfo>> finalQueryInfo;
    private final WarningCollector warningCollector;

    private QueryStateMachine(String query, Session session, URI self, Optional<ResourceGroupId> resourceGroup, Optional<QueryType> queryType, TransactionManager transactionManager, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.self = Objects.requireNonNull(self, "self is null");
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.queryStateTimer = new QueryStateTimer(ticker);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.QUEUED, QueryState.TERMINAL_QUERY_STATES);
        this.finalQueryInfo = new StateMachine("finalQueryInfo-" + this.queryId, executor, Optional.empty());
        this.outputManager = new QueryOutputManager(executor);
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public static QueryStateMachine begin(String query, Session session, URI self, ResourceGroupId resourceGroup, Optional<QueryType> queryType, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Metadata metadata, WarningCollector warningCollector) {
        return QueryStateMachine.beginWithTicker(query, session, self, resourceGroup, queryType, transactionControl, transactionManager, accessControl, executor, Ticker.systemTicker(), metadata, warningCollector);
    }

    static QueryStateMachine beginWithTicker(String query, Session session, URI self, ResourceGroupId resourceGroup, Optional<QueryType> queryType, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector) {
        if (!session.getTransactionId().isPresent() && !transactionControl) {
            TransactionId transactionId = transactionManager.beginTransaction(true);
            session = session.beginTransactionId(transactionId, transactionManager, accessControl);
        }
        QueryStateMachine queryStateMachine = new QueryStateMachine(query, session, self, Optional.of(resourceGroup), queryType, transactionManager, executor, ticker, metadata, warningCollector);
        queryStateMachine.addStateChangeListener(newState -> {
            QUERY_STATE_LOG.debug("Query %s is %s", new Object[]{queryStateMachine.getQueryId(), newState});
            if (newState.isDone()) {
                queryStateMachine.getSession().getTransactionId().ifPresent(transactionManager::trySetInactive);
            }
        });
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemory.get();
    }

    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemory.get();
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory.get();
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory.get();
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaTotalMemoryInBytes, long taskUserMemoryInBytes, long taskTotalMemoryInBytes) {
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
        this.peakTotalMemory.updateAndGet(currentPeakValue -> Math.max(this.currentTotalMemory.get(), currentPeakValue));
        this.peakTaskUserMemory.accumulateAndGet(taskUserMemoryInBytes, Math::max);
        this.peakTaskTotalMemory.accumulateAndGet(taskTotalMemoryInBytes, Math::max);
    }

    public BasicQueryInfo getBasicQueryInfo(Optional<BasicStageStats> rootStage) {
        ExecutionFailureInfo failureCause;
        QueryState state = this.queryState.get();
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        BasicStageStats stageStats = rootStage.orElse(BasicStageStats.EMPTY_STAGE_STATS);
        BasicQueryStats queryStats = new BasicQueryStats(this.queryStateTimer.getCreateTime(), this.getEndTime().orElse(null), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getExecutionTime(), stageStats.getTotalDrivers(), stageStats.getQueuedDrivers(), stageStats.getRunningDrivers(), stageStats.getCompletedDrivers(), stageStats.getRawInputDataSize(), stageStats.getRawInputPositions(), stageStats.getCumulativeUserMemory(), stageStats.getUserMemoryReservation(), stageStats.getTotalMemoryReservation(), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), stageStats.getTotalCpuTime(), stageStats.getTotalScheduledTime(), stageStats.isFullyBlocked(), stageStats.getBlockedReasons(), stageStats.getProgressPercentage());
        return new BasicQueryInfo(this.queryId, this.session.toSessionRepresentation(), this.resourceGroup, state, this.memoryPool.get().getId(), stageStats.isScheduled(), this.self, this.query, queryStats, errorCode == null ? null : errorCode.getType(), errorCode, this.queryType, this.warningCollector.getWarnings());
    }

    @VisibleForTesting
    QueryInfo getQueryInfo(Optional<StageInfo> rootStage) {
        QueryState state = this.queryState.get();
        ExecutionFailureInfo failureCause = null;
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        boolean completeInfo = StageInfo.getAllStages(rootStage).stream().allMatch(StageInfo::isFinalStageInfo);
        boolean isScheduled = QueryStateMachine.isScheduled(rootStage);
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.memoryPool.get().getId(), isScheduled, this.self, this.outputManager.getQueryOutputInfo().map(QueryExecution.QueryOutputInfo::getColumnNames).orElse((List)ImmutableList.of()), this.query, this.getQueryStats(rootStage), Optional.ofNullable(this.setCatalog.get()), Optional.ofNullable(this.setSchema.get()), Optional.ofNullable(this.setPath.get()), this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureCause, errorCode, this.warningCollector.getWarnings(), this.inputs.get(), this.output.get(), completeInfo, this.resourceGroup, this.queryType);
    }

    private QueryStats getQueryStats(Optional<StageInfo> rootStage) {
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long writtenOutputPositions = 0L;
        long writtenOutputLogicalDataSize = 0L;
        long writtenOutputPhysicalDataSize = 0L;
        long writtenIntermediatePhysicalDataSize = 0L;
        ImmutableList.Builder stageGcStatistics = ImmutableList.builder();
        boolean fullyBlocked = rootStage.isPresent();
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        ImmutableList.Builder operatorStatsSummary = ImmutableList.builder();
        boolean completeInfo = true;
        for (StageInfo stageInfo : StageInfo.getAllStages(rootStage)) {
            StageStats stageStats = stageInfo.getStageStats();
            totalTasks += stageStats.getTotalTasks();
            runningTasks += stageStats.getRunningTasks();
            completedTasks += stageStats.getCompletedTasks();
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            blockedDrivers += stageStats.getBlockedDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + stageStats.getCumulativeUserMemory());
            userMemoryReservation += stageStats.getUserMemoryReservation().toBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.MILLISECONDS);
            if (!stageInfo.getState().isDone()) {
                fullyBlocked &= stageStats.isFullyBlocked();
                blockedReasons.addAll(stageStats.getBlockedReasons());
            }
            if (stageInfo.getPlan().isPresent()) {
                PlanFragment plan = stageInfo.getPlan().get();
                if (!plan.getTableScanSchedulingOrder().isEmpty()) {
                    rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                    rawInputPositions += stageStats.getRawInputPositions();
                    processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                    processedInputPositions += stageStats.getProcessedInputPositions();
                }
                if (plan.isMaterializedExchangeSource()) {
                    writtenOutputPhysicalDataSize += stageStats.getPhysicalWrittenDataSize().toBytes();
                } else {
                    writtenOutputPositions += stageInfo.getStageStats().getOperatorSummaries().stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(OperatorStats::getInputPositions).sum();
                    writtenOutputLogicalDataSize += stageInfo.getStageStats().getOperatorSummaries().stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(stats -> stats.getInputDataSize().toBytes()).sum();
                    writtenOutputPhysicalDataSize += stageStats.getPhysicalWrittenDataSize().toBytes();
                }
            }
            stageGcStatistics.add((Object)stageStats.getGcInfo());
            completeInfo = completeInfo && stageInfo.isFinalStageInfo();
            operatorStatsSummary.addAll(stageInfo.getStageStats().getOperatorSummaries());
        }
        if (rootStage.isPresent()) {
            StageStats outputStageStats = rootStage.get().getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        boolean isScheduled = QueryStateMachine.isScheduled(rootStage);
        return new QueryStats(this.queryStateTimer.getCreateTime(), this.getExecutionStartTime().orElse(null), this.getLastHeartbeat(), this.getEndTime().orElse(null), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getResourceWaitingTime(), this.queryStateTimer.getExecutionTime(), this.queryStateTimer.getAnalysisTime(), this.queryStateTimer.getPlanningTime(), this.queryStateTimer.getFinishingTime(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTaskUserMemory()), DataSize.succinctBytes((long)this.getPeakTaskTotalMemory()), isScheduled, Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.MILLISECONDS), fullyBlocked, blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, writtenOutputPositions, DataSize.succinctBytes((long)writtenOutputLogicalDataSize), DataSize.succinctBytes((long)writtenOutputPhysicalDataSize), DataSize.succinctBytes((long)writtenIntermediatePhysicalDataSize), (List<StageGcStatistics>)stageGcStatistics.build(), (List<OperatorStats>)operatorStatsSummary.build());
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return this.memoryPool.get();
    }

    public void setMemoryPool(VersionedMemoryPoolId memoryPool) {
        this.memoryPool.set(Objects.requireNonNull(memoryPool, "memoryPool is null"));
    }

    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.outputManager.addOutputInfoListener(listener);
    }

    public void setColumns(List<String> columnNames, List<Type> columnTypes) {
        this.outputManager.setColumns(columnNames, columnTypes);
    }

    public void updateOutputLocations(Map<URI, TaskId> newExchangeLocations, boolean noMoreExchangeLocations) {
        this.outputManager.updateOutputLocations(newExchangeLocations, noMoreExchangeLocations);
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public void setOutput(Optional<Output> output) {
        Objects.requireNonNull(output, "output is null");
        this.output.set(output);
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void setSetCatalog(String catalog) {
        this.setCatalog.set(Objects.requireNonNull(catalog, "catalog is null"));
    }

    public void setSetSchema(String schema) {
        this.setSchema.set(Objects.requireNonNull(schema, "schema is null"));
    }

    public void setSetPath(String path) {
        Objects.requireNonNull(path, "path is null");
        this.setPath.set(path);
    }

    public String getSetPath() {
        return this.setPath.get();
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public void addSetRole(String catalog, SelectedRole role) {
        this.setRoles.put(Objects.requireNonNull(catalog, "catalog is null"), Objects.requireNonNull(role, "role is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public void addPreparedStatement(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.addedPreparedStatements.put(key, value);
    }

    public void removePreparedStatement(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!this.session.getPreparedStatements().containsKey(key)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + key);
        }
        this.deallocatedPreparedStatements.add(key);
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToWaitingForResources() {
        this.queryStateTimer.beginWaitingForResources();
        return this.queryState.setIf(QueryState.WAITING_FOR_RESOURCES, currentState -> currentState.ordinal() < QueryState.WAITING_FOR_RESOURCES.ordinal());
    }

    public boolean transitionToPlanning() {
        this.queryStateTimer.beginPlanning();
        return this.queryState.setIf(QueryState.PLANNING, currentState -> currentState.ordinal() < QueryState.PLANNING.ordinal());
    }

    public boolean transitionToStarting() {
        this.queryStateTimer.beginStarting();
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState.ordinal() < QueryState.STARTING.ordinal());
    }

    public boolean transitionToRunning() {
        this.queryStateTimer.beginRunning();
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState.ordinal() < QueryState.RUNNING.ordinal());
    }

    public boolean transitionToFinishing() {
        this.queryStateTimer.beginFinishing();
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        Optional<TransactionId> transactionId = this.session.getTransactionId();
        if (transactionId.isPresent() && this.transactionManager.transactionExists(transactionId.get()) && this.transactionManager.isAutoCommit(transactionId.get())) {
            ListenableFuture<?> commitFuture = this.transactionManager.asyncCommit(transactionId.get());
            Futures.addCallback(commitFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    QueryStateMachine.this.transitionToFinished();
                }

                public void onFailure(Throwable throwable) {
                    QueryStateMachine.this.transitionToFailed(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            this.transitionToFinished();
        }
        return true;
    }

    private void transitionToFinished() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            QUERY_STATE_LOG.debug(throwable, "Query %s failed", new Object[]{this.queryId});
            this.session.getTransactionId().ifPresent(transactionId -> {
                if (this.transactionManager.isAutoCommit((TransactionId)transactionId)) {
                    this.transactionManager.asyncAbort((TransactionId)transactionId);
                } else {
                    this.transactionManager.fail((TransactionId)transactionId);
                }
            });
        } else {
            QUERY_STATE_LOG.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
        }
        return failed;
    }

    public boolean transitionToCanceled() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.failureCause.compareAndSet(null, Failures.toFailure((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled")));
        boolean canceled = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (canceled) {
            this.session.getTransactionId().ifPresent(transactionId -> {
                if (this.transactionManager.isAutoCommit((TransactionId)transactionId)) {
                    this.transactionManager.asyncAbort((TransactionId)transactionId);
                } else {
                    this.transactionManager.fail((TransactionId)transactionId);
                }
            });
        }
        return canceled;
    }

    private void cleanupQueryQuietly() {
        try {
            this.metadata.cleanupQuery(this.session);
        }
        catch (Throwable t) {
            QUERY_STATE_LOG.error("Error cleaning up query: %s", new Object[]{t});
        }
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public void addQueryInfoStateChangeListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalQueryInfo -> {
            if (finalQueryInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((QueryInfo)finalQueryInfo.get());
            }
        };
        this.finalQueryInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public void recordHeartbeat() {
        this.queryStateTimer.recordHeartbeat();
    }

    public void beginAnalysis() {
        this.queryStateTimer.beginAnalyzing();
    }

    public void endAnalysis() {
        this.queryStateTimer.endAnalysis();
    }

    public DateTime getCreateTime() {
        return this.queryStateTimer.getCreateTime();
    }

    public Optional<DateTime> getExecutionStartTime() {
        return this.queryStateTimer.getExecutionStartTime();
    }

    public DateTime getLastHeartbeat() {
        return this.queryStateTimer.getLastHeartbeat();
    }

    public Optional<DateTime> getEndTime() {
        return this.queryStateTimer.getEndTime();
    }

    private static boolean isScheduled(Optional<StageInfo> rootStage) {
        if (!rootStage.isPresent()) {
            return false;
        }
        return StageInfo.getAllStages(rootStage).stream().map(StageInfo::getState).allMatch(state -> state == StageState.RUNNING || state.isDone());
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        if (this.queryState.get() != QueryState.FAILED) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.failureCause.get());
    }

    public Optional<QueryInfo> getFinalQueryInfo() {
        return this.finalQueryInfo.get();
    }

    public QueryInfo updateQueryInfo(Optional<StageInfo> stageInfo) {
        QueryInfo queryInfo = this.getQueryInfo(stageInfo);
        if (queryInfo.isFinalQueryInfo()) {
            this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(queryInfo));
        }
        return queryInfo;
    }

    public void pruneQueryInfo() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (!finalInfo.isPresent() || !finalInfo.get().getOutputStage().isPresent()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        Optional<StageInfo> prunedOutputStage = queryInfo.getOutputStage().map(outputStage -> new StageInfo(outputStage.getStageId(), outputStage.getState(), outputStage.getSelf(), Optional.empty(), outputStage.getTypes(), outputStage.getStageStats(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), outputStage.getFailureCause()));
        QueryInfo prunedQueryInfo = new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), this.getMemoryPool().getId(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), QueryStateMachine.pruneQueryStats(queryInfo.getQueryStats()), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetPath(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), prunedOutputStage, queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getWarnings(), queryInfo.getInputs(), queryInfo.getOutput(), queryInfo.isCompleteInfo(), queryInfo.getResourceGroupId(), queryInfo.getQueryType());
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    private static QueryStats pruneQueryStats(QueryStats queryStats) {
        return new QueryStats(queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getLastHeartbeat(), queryStats.getEndTime(), queryStats.getElapsedTime(), queryStats.getQueuedTime(), queryStats.getResourceWaitingTime(), queryStats.getExecutionTime(), queryStats.getAnalysisTime(), queryStats.getTotalPlanningTime(), queryStats.getFinishingTime(), queryStats.getTotalTasks(), queryStats.getRunningTasks(), queryStats.getCompletedTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getBlockedDrivers(), queryStats.getCompletedDrivers(), queryStats.getCumulativeUserMemory(), queryStats.getUserMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskUserMemory(), queryStats.getPeakTaskTotalMemory(), queryStats.isScheduled(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getTotalBlockedTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getProcessedInputDataSize(), queryStats.getProcessedInputPositions(), queryStats.getOutputDataSize(), queryStats.getOutputPositions(), queryStats.getWrittenOutputPositions(), queryStats.getWrittenOutputLogicalDataSize(), queryStats.getWrittenOutputPhysicalDataSize(), queryStats.getWrittenIntermediatePhysicalDataSize(), queryStats.getStageGcStatistics(), (List<OperatorStats>)ImmutableList.of());
    }

    public static class QueryOutputManager {
        private final Executor executor;
        @GuardedBy(value="this")
        private final List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners = new ArrayList<Consumer<QueryExecution.QueryOutputInfo>>();
        @GuardedBy(value="this")
        private List<String> columnNames;
        @GuardedBy(value="this")
        private List<Type> columnTypes;
        @GuardedBy(value="this")
        private final Map<URI, TaskId> exchangeLocations = new LinkedHashMap<URI, TaskId>();
        @GuardedBy(value="this")
        private boolean noMoreExchangeLocations;

        public QueryOutputManager(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(listener, "listener is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                this.outputInfoListeners.add(listener);
                queryOutputInfo = this.getQueryOutputInfo();
            }
            queryOutputInfo.ifPresent(info -> this.executor.execute(() -> listener.accept((QueryExecution.QueryOutputInfo)info)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColumns(List<String> columnNames, List<Type> columnTypes) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(columnNames, "columnNames is null");
            Objects.requireNonNull(columnTypes, "columnTypes is null");
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must be the same size");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                Preconditions.checkState((this.columnNames == null && this.columnTypes == null ? 1 : 0) != 0, (Object)"output fields already set");
                this.columnNames = ImmutableList.copyOf(columnNames);
                this.columnTypes = ImmutableList.copyOf(columnTypes);
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$setColumns$2((List)outputInfoListeners, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateOutputLocations(Map<URI, TaskId> newExchangeLocations, boolean noMoreExchangeLocations) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(newExchangeLocations, "newExchangeLocations is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                if (this.noMoreExchangeLocations) {
                    Preconditions.checkArgument((boolean)this.exchangeLocations.keySet().containsAll(newExchangeLocations.keySet()), (Object)"New locations added after no more locations set");
                    return;
                }
                this.exchangeLocations.putAll(newExchangeLocations);
                this.noMoreExchangeLocations = noMoreExchangeLocations;
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$updateOutputLocations$3((List)outputInfoListeners, arg_0));
        }

        private synchronized Optional<QueryExecution.QueryOutputInfo> getQueryOutputInfo() {
            if (this.columnNames == null || this.columnTypes == null) {
                return Optional.empty();
            }
            return Optional.of(new QueryExecution.QueryOutputInfo(this.columnNames, this.columnTypes, this.exchangeLocations, this.noMoreExchangeLocations));
        }

        private void fireStateChanged(QueryExecution.QueryOutputInfo queryOutputInfo, List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners) {
            for (Consumer<QueryExecution.QueryOutputInfo> outputInfoListener : outputInfoListeners) {
                this.executor.execute(() -> outputInfoListener.accept(queryOutputInfo));
            }
        }

        private /* synthetic */ void lambda$updateOutputLocations$3(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }

        private /* synthetic */ void lambda$setColumns$2(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }
    }
}

