/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.OptionalInt;

public class MemoryTrackingRemoteTaskFactory
implements RemoteTaskFactory {
    private final RemoteTaskFactory remoteTaskFactory;
    private final QueryStateMachine stateMachine;

    public MemoryTrackingRemoteTaskFactory(RemoteTaskFactory remoteTaskFactory, QueryStateMachine stateMachine) {
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OptionalInt totalPartitions, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, boolean summarizeTaskInfo) {
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(session, taskId, node, fragment, initialSplits, totalPartitions, outputBuffers, partitionedSplitCountTracker, summarizeTaskInfo);
        task.addStateChangeListener(new UpdatePeakMemory(this.stateMachine));
        return task;
    }

    private static final class UpdatePeakMemory
    implements StateMachine.StateChangeListener<TaskStatus> {
        private final QueryStateMachine stateMachine;
        private long previousUserMemory;
        private long previousSystemMemory;

        public UpdatePeakMemory(QueryStateMachine stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public synchronized void stateChanged(TaskStatus newStatus) {
            long currentUserMemory = newStatus.getMemoryReservation().toBytes();
            long currentSystemMemory = newStatus.getSystemMemoryReservation().toBytes();
            long currentTotalMemory = currentUserMemory + currentSystemMemory;
            long deltaUserMemoryInBytes = currentUserMemory - this.previousUserMemory;
            long deltaTotalMemoryInBytes = currentTotalMemory - (this.previousUserMemory + this.previousSystemMemory);
            this.previousUserMemory = currentUserMemory;
            this.previousSystemMemory = currentSystemMemory;
            this.stateMachine.updateMemoryUsage(deltaUserMemoryInBytes, deltaTotalMemoryInBytes, currentUserMemory, currentTotalMemory);
        }
    }
}

