/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class Lifespan {
    private static final Lifespan TASK_WIDE = new Lifespan(false, 0);
    private final boolean grouped;
    private final int groupId;

    public static Lifespan taskWide() {
        return TASK_WIDE;
    }

    public static Lifespan driverGroup(int id) {
        return new Lifespan(true, id);
    }

    private Lifespan(boolean grouped, int groupId) {
        this.grouped = grouped;
        this.groupId = groupId;
    }

    public boolean isTaskWide() {
        return !this.grouped;
    }

    public int getId() {
        Preconditions.checkState((boolean)this.grouped);
        return this.groupId;
    }

    @JsonCreator
    public static Lifespan jsonCreator(String value) {
        if (value.equals("TaskWide")) {
            return Lifespan.taskWide();
        }
        Preconditions.checkArgument((boolean)value.startsWith("Group"));
        return Lifespan.driverGroup(Integer.parseInt(value.substring("Group".length())));
    }

    @JsonValue
    public String toString() {
        return this.grouped ? "Group" + this.groupId : "TaskWide";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lifespan that = (Lifespan)o;
        return this.grouped == that.grouped && this.groupId == that.groupId;
    }

    public int hashCode() {
        return Objects.hash(this.grouped, this.groupId);
    }
}

